# --- ${BLDDIR}signals.h

if test -n "$B_signals_h"
then

F_define=yep

echo
echo Building ${BLDDIR}signals.h... | tr -d '\012'
if test -n "$LINUX" -o -n "$UNICOS" -o -n "$AIX" -o -n "$SCO"
# Awk script taken from Larry Wall's perl Configure script
then 
if test -n "$LINUX"
then sigfile=/usr/include/linux/signal.h
else sigfile=/usr/include/sys/signal.h
fi
echo `cat $sigfile 2>&1 | awk '
$1 ~ /^#define$/ && $2 ~ /^SIG[A-Z0-9]*$/ && $3 ~ /^[1-9][0-9]*$/ {
	if (sig[$3] == "") {
	sig[$3] = substr($2,4,20)
    if (max < $3 && $3 < 60) {
	max = $3
	}
	}
}
# next case handles "# define SIGx y"
$1 ~ /^#$/ && $2 ~ /^define$/ && $3 ~ /^SIG[A-Z0-9]*$/ && $4 ~ /^[1-9][0-9]*$/ {
	if (sig[$4] == "") {
    sig[$4] = substr($3,4,20)
    if (max < $4 && $4 < 60) {
	max = $4
	}
    }
}
END {
    for (i=1; i<=max; i++) {
	if (sig[i] == "")
	    printf "%d", i
	else
	    printf "%s", sig[i]
	if (i < max)
	    printf " "
    }
    printf "\n"
}
'` | tr ' ' '\012' > ${BLDDIR}signals.h
else echo `csh -fc 'kill -l'` | tr ' ' '\012' >${BLDDIR}signals.h
fi
lct=`wc -l < ${BLDDIR}signals.h`
cp ${BLDDIR}signals.h ${BLDDIR}signams.h
(
cat <<foo
/* signals.h */
/* architecture-customized signals.h for $VERSION
 * for architecture "$arch",
 * automagically generated by buildzsh -- do not edit */
/* if all this is wrong, blame csh ;-) */

#define SIGCOUNT $lct

#ifdef GLOBALS

char *sigmsg[SIGCOUNT+2] = {
	"done",
foo

sed -e 's/^/SIG/' -e '/SIGHUP/s//hangup/
/SIGINT/s//interrupt/
/SIGQUIT/s//quit/
/SIGILL/s//illegal instruction/
/SIGTRAP/s//trace trap/
/SIGIOT/s//IOT instruction/
/SIGABRT/s//abort/
/SIGEMT/s//EMT instruction/
/SIGFPE/s//floating point exception/
/SIGKILL/s//killed/
/SIGBUS/s//bus error/
/SIGSEGV/s//segmentation fault/
/SIGSYS/s//bad system call/
/SIGPIPE/s//broken pipe/
/SIGTERM/s//terminated/
/SIGPWR/s//power fail/
/SIGVTALRM/s//virtual time alarm/
/SIGCONT/s//continued/
/SIGALRM/s//alarm/
/SIGUSR1/s//user signal 1/
/SIGUSR2/s//user signal 2/
/SIGCHLD/s//death of child/
/SIGIO/s//i\/o ready/
/SIGPROF/s//profile signal/
/SIGWINCH/s//window size changed/
/SIGXCPU/s//cpu limit exceeded/
/SIGXFSZ/s//filesize limit exceeded/' -e 's/.*/	"&",/' ${BLDDIR}signals.h
echo '	NULL
};

char *sigs[SIGCOUNT+4] = {
	"EXIT",' ) >${BLDDIR}sigtmp.h
mv ${BLDDIR}sigtmp.h ${BLDDIR}signals.h
if grep SIGSTOP ${BLDDIR}signals.h >/dev/null
then ed ${BLDDIR}signals.h <<'foo' >/dev/null 2>&1
/SIGSTOP/c
#ifdef USE_SUSPENDED
	"suspended (signal)",
#else
	"stopped (signal)",
#endif
.
/SIGTSTP/c
#ifdef USE_SUSPENDED
	"suspended",
#else
	"stopped",
#endif
.
/SIGTTIN/c
#ifdef USE_SUSPENDED
	"suspended (tty input)",
#else
	"stopped (tty input)",
#endif
.
/SIGTTOU/c
#ifdef USE_SUSPENDED
	"suspended (tty output)",
#else
	"stopped (tty output)",
#endif
.
w
q
foo
fi
(sed 's/.*/	"&",/' ${BLDDIR}signams.h
echo '	"ZERR",'
echo '	"DEBUG",
	NULL
};

#else

extern char *sigs[SIGCOUNT+4],*sigmsg[SIGCOUNT+2];

#endif') >>${BLDDIR}signals.h
rm ${BLDDIR}signams.h
echo done
fi
