#! /bin/sh
# zipgrep: searches the given zip members for a string or pattern
# This shell script assumes that you have installed unzip and zipinfo, which
# are part of the unzip package.

pat=""
opt=""
while test $# -ne 0; do
  case "$1" in
  -e | -f) opt="$opt $1"; shift; pat="$1";;
  -*)	   opt="$opt $1";;
   *)      if test -z "$pat"; then
	     pat="$1"
	   else
	     break;
           fi;;
  esac
  shift
done

if test $# = 0; then
  echo "usage: `basename $0` [egrep_options] pattern zipfile [members...]"
  echo searches the given zip members for a string or pattern
  exit 1
fi
zipfile="$1"; shift

list=0
silent=0
opt=`echo "$opt" | sed -e 's/ //g' -e 's/-//g'`
case "$opt" in
  *l*) list=1; opt=`echo $opt | sed s/l//`
esac
case "$opt" in
  *h*) silent=1
esac
if test -n "$opt"; then
  opt="-$opt"
fi

res=0
for i in `zipinfo -1 "$zipfile" ${1+"$@"}`; do
  if test $list -eq 1; then

    unzip -p "$zipfile" "$i" | egrep $opt "$pat" > /dev/null && echo $i
    r=$?
  elif test $silent -eq 1; then

    unzip -p "$zipfile" "$i" | egrep $opt "$pat"
    r=$?
  else
    unzip -p "$zipfile" "$i" | egrep $opt "$pat" | sed "s|^|${i}:|"
    r=$?
  fi
  test "$r" -ne 0 && res="$r"
done
exit $res
