/*
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI timestamp.c,v 1.2 1995/08/03 15:59:48 bostic Exp
 */

#include <sys/types.h>
#include <sys/uio.h>

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

void usage __P((void));

int
main(argc, argv)
	int argc;
	char *argv[];
{
	struct iovec iov[3];
	time_t t;
	int ch;
	char *fmt, buf[128];

	fmt = "[%T]";
	while ((ch = getopt(argc, argv, "f:")) != -1)
		switch (ch) {
		case 'f':
			fmt = optarg;
			break;
		case '?':
		default:
			usage();
			/* NOTREACHED */
		}
	argc -= optind;
	argv += optind;

	/*
	 * Initialize what we can.  We use writev(2) because timestamp is
	 * a filter, and can't take any risks of discarding input.  If we
	 * use stdio(3), nul's in the input stream will cause other input
	 * to be discarded.  Fgetln(3) is newline, not nul, oriented, and
	 * should be safe.
	 */
	iov[0].iov_base = buf;
	iov[1].iov_len = 1;
	iov[1].iov_base = " ";
	while ((iov[2].iov_base = fgetln(stdin, &iov[2].iov_len)) != NULL) {
		(void)time(&t);
		iov[0].iov_len = strftime(buf, sizeof(buf), fmt, localtime(&t));
		if (writev(STDOUT_FILENO, iov, 3) == -1)
			err(1, "stdout");
	}
	if (ferror(stdin) || fclose(stdin))
		err(1, "stdin");
	exit(0);
}

void
usage()
{
	(void)fprintf(stderr, "usage: timestamp [-f format]\n");
	exit(1);
}
