/*	BSDI skeyinit.c,v 1.2 1995/08/18 04:01:31 prb Exp */
/*   change password or add user to S/KEY authentication system.
 *   S/KEY is a tradmark of Bellcore  */

#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include "skey.h"
#include <stdio.h>
#include <time.h>

extern int optind;
extern char *optarg;

char * readpass();

int skeylookup __ARGS((struct skey *mp,char *name));

#define NAMELEN 2
int
main(argc,argv)
int argc;
char *argv[];
{
	struct skey skey;
	int rval,n,nn,i,defaultsetup;
	char seed[18],tmp[80],key[8];
	struct passwd *ppuser,*pp;
	char defaultseed[17], passwd[256],passwd2[256] ;
	char *instance = 0;


	time_t now;
	struct tm *tm;
	char tbuf[27],buf[60];
	char lastc, me[80];
	int l;

	time(&now);
	tm = localtime(&now);
	strftime(tbuf, sizeof(tbuf), "%M%j", tm);
	gethostname(tmp,sizeof(tmp));
    	strncpy(defaultseed, tmp, NAMELEN+1);
	for (l = 0; l < NAMELEN; ++l)
	    	if (!defaultseed[l])
			defaultseed[l] = 'a'+l;
	strcpy(&defaultseed[NAMELEN],tbuf);

	pp = ppuser = getpwuid(getuid());
	strcpy(me, pp->pw_name);
	defaultsetup = 1;
	while ((i = getopt(argc, argv, "m:s")) != EOF) {
		switch (i) {
		case 's':
			defaultsetup = 0;
			break;
		case 'm':
			switch (atoi(optarg)) {
			case 4:
				skeymode = SKEY_MD4;
				break;
			case 5:
				skeymode = SKEY_MD5;
				break;
			default:
				errx(1, "MD%s not supported", optarg);
			}
			break;
		default:
		usage:
			errx(1, "Usage: skeyinit [-s] [-m {4,5}] user");
		}
	}
	if (optind + 1 == argc) {
		if (instance = strchr(argv[optind], '.'))
			*instance = 0;
		pp = getpwnam(argv[optind]);
		if (instance) {
			*instance = '.';
			instance = argv[optind];
		}
	} else if (optind != argc)
		goto usage;

	if(pp == NULL){
		printf("User unknown\n");
		return 1;
	}
	if(strcmp(pp->pw_name, me) != 0){
		if(getuid() != 0){
			/* Only root can change other's passwds */
			printf("Permission denied.\n");
			return(1);
		}
	}



	rval = skeylookup(&skey, instance ? instance : pp->pw_name);
	switch(rval){
	case -1:
		perror("error in opening database");
		return 1;
	case 0:
		if (instance && getuid() && defaultsetup) {
			fprintf(stderr, "Only root may add new instances.\n");
			exit(1);
		}
		if (skey.mode && skey.mode != skeymode)
			printf("Warning, changing from %s to %s\n", skey.mode, skeymode);
		printf("Updating %s:\n", instance ? instance : pp->pw_name);
		printf("Old key: %s\n",skey.seed);
		/* lets be nice if they have a skey.seed that ends in 0-8 just add one*/
		l = strlen(skey.seed);
		if( l > 0){
			lastc = skey.seed[l-1];
			if( isdigit(lastc) && lastc != '9' ){
				strcpy(defaultseed, skey.seed);
				defaultseed[l-1] = lastc + 1;
			}
			if( isdigit(lastc) && lastc == '9' && l < 16){
				strcpy(defaultseed, skey.seed);
				defaultseed[l-1] = '0';
				defaultseed[l] = '0';
				defaultseed[l+1] = '\0';
			}
		}
		break;
	case 1:
		if (instance && getuid()) {
			fprintf(stderr, "Only root may add new instances.\n");
			exit(1);
		}
		printf("Adding %s:\n", instance);
		break;
	}
	fprintf(stderr,"Using %s\n", skeymode);
    n = 99;
    if( ! defaultsetup){
	printf("Reminder you need the 6 english words from the skey command.\n");
	for(i=0;;i++){
		if(i >= 2) exit(1);
		printf("Enter sequence count from 1 to 10000: ");
		fgets(tmp,sizeof(tmp),stdin);
		n = atoi(tmp);
		if(n > 0 && n < 10000)
			break;	/* Valid range */
		printf("Count must be > 0 and < 10000\n");
	}
    }
    if( !defaultsetup){
	printf("Enter new key [default %s]: ", defaultseed);
	fflush(stdout);
	fgets(seed,sizeof(seed),stdin);
	rip(seed);
	if(strlen(seed) > 16){
		printf("Seed truncated to 16 chars\n");
		seed[16] = '\0';
	}
	if( seed[0] == '\0') strcpy(seed,defaultseed);
	for(i=0;;i++){
		if(i >= 2) exit(1);
		printf("S/Key (%s) %d %s\ns/key access password: ",
			skeymode, n, seed);
		fgets(tmp,sizeof(tmp),stdin);
		rip(tmp);
		backspace(tmp);
		if(tmp[0] == '?'){
			printf("Enter 6 English words from secure S/Key calculation.\n");
			continue;
		}
		if(tmp[0] == '\0'){
			exit(1);
		}
		if(etob(key,tmp) == 1 || atob8(key,tmp) == 0)
			break;	/* Valid format */
		printf("Invalid format, try again with 6 English words.\n");
	}
    } else {
	/* Get user's secret password */
	fprintf(stderr,"Reminder - Only use this method if you are direct connected.\n");
	fprintf(stderr,"If you are using telnet or dial-in exit with no password and use keyinit -s.\n");
	/* NOTE from Dan McD.:  Ran Atkinson suggested that maybe an
	   environment check for the DISPLAY variable would be in order.  
	   If DISPLAY was not local, bail out of the program and display
	   a suitable warning message.  This would be a nice addition. */

	for(i=0;;i++){
		if(i >= 2) exit(1);
		fprintf(stderr,"Enter secret password: ");
		readpass(passwd,sizeof(passwd));
		if(passwd[0] == '\0'){
			exit(1);
		}
		fprintf(stderr,"Again secret password: ");
		readpass(passwd2,sizeof(passwd));
		if(passwd2[0] == '\0'){
			exit(1);
		}
		if(strlen(passwd) < 4 && strlen(passwd2) < 4) {
			fprintf(stderr, "Sorry your password must be longer\n\r");
			exit(1);
		}
		if(strcmp(passwd,passwd2) == 0) break;
		fprintf(stderr, "Sorry no match\n");
		
	
	}
	strcpy(seed,defaultseed);

	/* Crunch seed and password into starting key */
	if(keycrunch(key,seed,passwd) != 0){
		fprintf(stderr,"%s: key crunch failed\n",argv[0]);
		return 1;
	}
	nn = n;
	while(nn-- != 0)
		f(key);
    }
	time(&now);
	tm = localtime(&now);
	strftime(tbuf, sizeof(tbuf), " %b %d,%Y %T", tm);
        if (skey.val == NULL)
                  skey.val = (char *) malloc(16+1);

	btoa8(skey.val,key);
#if	1
	skey.logname = instance ? instance : pp->pw_name;
	skey.n = n;
	skey.mode = skeymode;
	skey.seed = seed;
	skey.tbuf = tbuf;
	skeyput(&skey);
#else
	fprintf(skey.keyfile,"%s %s %04d %-16s %s %-21s\n",pp->pw_name,skeymode,n,seed,skey.val,tbuf);
	fclose(skey.keyfile);
#endif
	printf("\nID %s s/key is %d %s\n", instance ? instance : pp->pw_name,
	    n,seed);
	printf("%s\n",btoe(buf,key));
#ifdef HEXIN
	printf("%s\n",put8(buf,key));
#endif
	return 0;
}
