/*	BSDI skey.c,v 1.3 1995/11/27 18:02:59 polk Exp */

/* Stand-alone program for computing responses to S/Key challenges.
 * Takes the iteration count and seed as command line args, prompts
 * for the user's key, and produces both word and hex format responses.
 *
 * Usage example:
 *	>skey 88 ka9q2
 *	Enter password:
 *	OMEN US HORN OMIT BACK AHOY
 *	C848 666B 6435 0A93
 *	>
 */
#include <stdio.h>
#ifdef HASSTDLIB
#include <stdlib.h>
#else
#include <sys/types.h>
#endif
#include <string.h>
#ifdef	__MSDOS__
#include <dos.h>
#else	/* Assume BSD unix */
#include <fcntl.h>
#include <sgtty.h>
#endif

#include "skey.h"

char *readpass();
void usage();
int getopt();
extern int optind;
extern char *optarg;

int
main(argc,argv)
int argc;
char *argv[];
{
	int n,cnt,i;
#ifdef MJR
	int  desmode = 0;
#endif
	char passwd[256],passwd2[256];
	char key[8];
	char *seed;
	char buf[33];
	char *slash;
	int mdmode = 0;

	cnt = 1;
	while((i = getopt(argc,argv,"m:n:")) != EOF){
		switch(i){
#ifdef MJR
		case 'd':
		  desmode++;
		  break;
#endif
		case 'm':
			switch (mdmode = atoi(optarg)) {
			case 4:
			case 5:
				break;
			default:
				usage();
			}
			break;
		case 'n':
			cnt = atoi(optarg);
			break;
		}
	}
	if (!mdmode && optind < argc) {
		if (strstr(argv[optind], "MD4") ||
		    strstr(argv[optind], "md4") ||
		    strstr(argv[optind], "Md4") ||
		    strstr(argv[optind], "mD4")) {
			mdmode = 4;
			++optind;
		} else if (strstr(argv[optind], "MD5") ||
		    strstr(argv[optind], "md5") ||
		    strstr(argv[optind], "Md5") ||
		    strstr(argv[optind], "mD5")) {
			mdmode = 5;
			++optind;
		}
	}

	switch(mdmode) {
	case 4:
		skeymode = SKEY_MD4;
		break;
	case 5:
		skeymode = SKEY_MD5;
		break;
	default:
		printf("Defaulting to %s\n", skeymode);
		break;
	}

	/* could be in the form <number>/<seed> */
	if(argc <= optind + 1){
		/*look for / in it */
		if(argc <= optind){
			usage(argv[0]);
			return 1;
		}

		slash = strchr(argv[optind], '/');
		if(slash == NULL){
			usage(argv[0]);
			return 1;
		}
		*slash++ = '\0';
		seed = slash;

		if((n = atoi(argv[optind])) < 0){
			fprintf(stderr,"%s not positive\n",argv[optind]);
			usage(argv[0]);
			return 1;
		}
	}
	else {

		if((n = atoi(argv[optind])) < 0){
			fprintf(stderr,"%s not positive\n",argv[optind]);
			usage(argv[0]);
			return 1;
		}
		seed = argv[++optind];
	}
	fprintf(stderr,"Reminder - Do NOT use skey while logged in via telnet or dial-in.\n");
	fprintf(stderr,"Using %s\n", skeymode);

	/* Get user's secret password */

	/* NOTE from Dan McD:  This is a place where Ran Atkinson suggests
	   putting in a check for the DISPLAY environment variable.  If it
	   is set to non-local, exit the program at this point with a 
	   suitable diagnostic message. */

	for(;;){
		fprintf(stderr,"Enter secret password: ");
		readpass(passwd,sizeof(passwd));
		break;
	/************
		fprintf(stderr,"Again secret password: ");
		readpass(passwd2,sizeof(passwd));
		if(strcmp(passwd,passwd2) == 0) break;
		fprintf(stderr, "Sorry no match\n");
        **************/
	
	}

#ifdef MJR
	/* Crunch seed and password into starting key, optionally using DES */
	if(desmode ? deskeycrunch(key,seed,passwd) :
	  keycrunch(key, seed, passwd) !=0) {
	        fprintf(stderr,"%s: key crunch failed\n",argv[0]);
		return 1;
	}

#else  
	/* Crunch seed and password into starting key */
	if(keycrunch(key,seed,passwd) != 0){
		fprintf(stderr,"%s: key crunch failed\n",argv[0]);
		return 1;
	}
#endif
	if(cnt == 1){
		while(n-- != 0)
			f(key);
		printf("%s\n",btoe(buf,key));
#ifdef	HEXIN
		printf("%s\n",put8(buf,key));
#endif
	} else {
		for(i=0;i<=n-cnt;i++)
			f(key);
		for(;i<=n;i++){
#ifdef	HEXIN
			printf("%d: %-29s  %s\n",i,btoe(buf,key),put8(buf,key));
#else
			printf("%d: %-29s\n",i,btoe(buf,key));
#endif
			f(key);		
		}
	}
	return 0;
}
void
usage(s)
char *s;
{
	fprintf(stderr,"Usage: %s [-m {4,5}] [-n count] <sequence #>[/] <key> \n",s);
}

