/*
 *  pc_subrs.c
 *	Support for compiling psgraph on PC-based systems, which
 *	are missing things that Unix people take for granted.
 *  
 * Routines:
 *   copysign()
 *  SCO:
 *   gethostname()    
 *  MSDOS/OS2:
 *   int getuid()
 *   gethostname()
 *   struct passwd *getpwuid()
 *  
 */

#include "psgraph.h"

/* environment variable for hostname */
#ifndef ENV_PSGHOST
#define ENV_PSGHOST "PSGHOST"
#endif
/* environment variable for prologfile */
#ifndef ENV_PSGPROLOG
#define ENV_PSGPROLOG "PSGPROLOG"
#endif
/* environment variable for pw_name  */
#ifndef ENV_PSGUSERID
#define ENV_PSGUSERID "PSGUSER"
#endif
/* environment variable for pw_gecos */
#ifndef ENV_PSGUSERNAME
#define ENV_PSGUSERNAME "PSGUSERNAME"
#endif

#ifdef NOCOPYSIGN
double copysign(double x,double y) 
{
	return ((y)>=0.0?((x)<0.0?-(x):(x)):(x)<0.0?(x):-(x));
}
#endif

#ifdef MSDOS_OS2
/*
 *  Locate prolog file.
 *  Try first the one defined in environment variable.
 */
char *getprolog()
{
	char *p;
	if( (p=getenv(ENV_PSGPROLOG)) && access(p,04)==0 )
		return strdup(p);
	else 
		return "psgraph.pro";
}

/* 
 *  pwd simulation 
 *  user name and explanation are taken from environment
 */
struct passwd defaultuser;

struct passwd *getpwuid(int i)
{
	if( !defaultuser.pw_name )
		if( !(defaultuser.pw_name=getenv(ENV_PSGUSERID)) )
			defaultuser.pw_name="unknown";
		
	if( !defaultuser.pw_gecos )
		if( !(defaultuser.pw_gecos=getenv(ENV_PSGUSERNAME)) )
			defaultuser.pw_gecos="";

	return &defaultuser;
}

int getuid()
{
	return 0;
}

/*
 * strncpy with guaranteed null terminator
 */
static strnzcpy(char *t,char *s,int n)
{
	strncpy(t,s,n-1);
	t[n-1]='\0';
}

/*
 * Hostname is taken from environment , if one exists
 * Defaults to "MSDOS" and "OS2"
 */
gethostname(char *buffer, int len)
{
	char *p;
	if( p=getenv(ENV_PSGHOST))
		strnzcpy(buffer, p,len);
#ifdef MSDOS        
	else strnzcpy(buffer, "MSDOS", len);
#endif
#ifdef OS2
	else strnzcpy(buffer, "OS/2", len);
#endif  
}
#endif

/*
 *  Functions that SCO doesn't have
 */
#ifdef SCO
#include <sys/utsname.h>
static strnzcpy(char *t,char *s,int n)
{
	strncpy(t,s,n-1);
	t[n-1]='\0';
}

gethostname(char *buffer, int len)
{
	static struct utsname u;
	uname(&u);
	strnzcpy(buffer,u.sysname,len);
}
#endif
