// formantfilter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FormantFilter implements a time-varying All-Pass filter which gets its
// coefficients from an LPCData member stored in the LPC_Filter base class.
// This class is used for mapping LPC-related formants onto arbitrary sounds.

#ifndef FORMANTFILTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define FORMANTFILTER_H

#include "lpcfilter.h"
#include "iofunction.h"

class Controller;
class Request;
class LPCData;
struct QueryInfo;

class FormantFilter : private LPC_Filter, public SimpleInputOutputFunction {
	enum QSize { lpcQueueSize = 1024 };
public:
	FormantFilter(Data* input, Data* output, LPCData* data, double amp);
	FormantFilter(Data* input, Data* output, LPCData* data);
	static Modifier* create(class DataEditor *);
	redefined boolean configure(Controller *c);
	redefined void restoreState();
	redefined const char* message() { return "Formant Filtering..."; }
protected:
	redefined void initialize();
	redefined int doProcessing();
	redefined double doSimpleProcess(double);
	redefined boolean setValues(Request &r);
	redefined boolean confirmValues(Controller *);
private:
	redefined const QueryInfo *requestInfo();
private:
	double gain;
	float warpFactor;
};

#endif

