: run this script through /bin/sh

PERSON="$1" SERVER="$2" AREA="$3"
export PERSON

if [ -z "$PERSON" -o -z "$SERVER" -o -z "$AREA" -o ! -d "$AREA" ]; then
    exit 1
fi

GAWK="/usr/local/bin/gawk"
MHL="/usr/local/lib/mh/mhl -nobell"
MHMAIL="/usr/local/bin/mhmail"
SCAN="/usr/local/bin/scan -width 512"
MHN="/usr/local/bin/mhn"
SEND="/usr/local/bin/send"
FILE="/usr/bin/file"
VIAMAIL="/usr/local/lib/mh/viamail"
PATH=$PATH:/etc:/bin:/usr/ucb:/usr/bin:/usr/local/bin export PATH
if [ date +"%m/%d %T" > /dev/null 2>&1 ]; then
	DATE="date +\"%m/%d %T\" | tr '\012' ' '"
else
	DATE="date | ${GAWK} '{ printf \"%s %s %s \",  \$2, \$3, \$4 }'"
fi

P=/tmp/mail$$.prf   C=/tmp/mail$$.ctx	F=/tmp/mail$$	Z=/tmp/mail$$.log
M=1 N=2
trap "rm -rf $P $C $F $Z" 0 1 2 3 13 15

cd /tmp
umask 0022

echo "Path: /tmp" > $P
MH="$P" export MH

echo "Current-Folder: $F" > $C
MHCONTEXT="$C" export MHCONTEXT

mkdir $F
chmod 700 $F
sed -e 1d > $F/$M

FROM=`$SCAN -format "%<{reply-to}%{reply-to}%|%<{from}%{from}%|%<{sender}%{sender}%|%<{return-path}%{return-path}%>%>%>%>" $M`

SUBJECT=`$SCAN -format "%{subject}" $M | tr A-Z a-z`

cd $AREA

W="`whoami`"
STAMP="`echo $SERVER $$ $W | $GAWK '{ printf \"%-8.8s %05d (%-8s)\", $1, $2, $3; }'`"

(eval ${DATE})					 > $Z
echo "$STAMP" BEGIN "$FROM" "$SUBJECT"		>> $Z
cat $Z >> /var/tmp/mail-server.log

$MHL -form mhl.body < $F/$M | while read directive
do
    cmd="`echo "$directive" | sed -e s'%\([A-Za-z0-9-]*\).*%\1%' | tr A-Z a-z`"
    if [ -z "$cmd" ]; then
	continue
    fi;
		     
    (eval ${DATE})				 > $Z
    echo "$STAMP" "$directive"			>> $Z
    cat $Z >> /var/tmp/mail-server.log

    arg="`echo $directive | sed -e 's%[A-Za-z0-9-]*[ 	]*\(.*\)[ 	]*%\1%'`"
    case "$cmd" in
	path)	if [ -z "$arg" ]; then
		    (eval ${DATE})				    > $Z
		    echo "$STAMP" "path command requires argument" >> $Z
		    cat $Z >> /var/tmp/mail-server.log

		    $MHMAIL "$FROM" -subject "Re: $SUBJECT ($directive)" \
			-from "$PERSON" -cc "$PERSON" \
			-body "path command requires argument"
		else
		    FROM="$arg"
		    continue
		fi
		;;		

	send)	for P in $arg; do
		    if echo "$P" | egrep -s "\.\./|^/"; then
			(eval ${DATE})					 > $Z
			echo "$STAMP" "$P: invalid package"		>> $Z
			cat $Z >> /var/tmp/mail-server.log

			$MHMAIL "$FROM" -subject "Re: $SUBJECT ($directive)" \
			    -from "$PERSON" -cc "$PERSON" \
			    -body "$P: invalid package"

			break 2
		    fi
		    if [ ! -s "$P" ]; then
			(eval ${DATE})					 > $Z
			echo "$STAMP" "$P: no such package"		>> $Z
			cat $Z >> /var/tmp/mail-server.log

			$MHMAIL "$FROM" -subject "Re: $SUBJECT ($directive)" \
			    -from "$PERSON" -cc "$PERSON" \
			    -body "$P: no such package"


			break 2
		    fi
		    T="`${FILE} $P | ${GAWK} '{ print $2; }`"
		    if [ ! \( "$T" = "ascii" -o "$T" = "English" \) ]; then
			(case $P in
			    *.tar.Z)
				cat $P
				;;
			    *.tar)
				compress -c $P
				;;
			    *)
				tar cvf - $P | compress -c
				;;
			esac) | ${MHN} -viamail "$FROM" -viasubj "Re: $SUBJECT ($directive)" \
					-viaparm "type=tar; conversions=x-compress" \
					-viacmnt "extract with uncompress | tar xvpf -" \
					-viadelay 180 \
					-verbose "$PERSON" 
			if [ $? -eq 0 ]; then
			    true
			else
			    (eval ${DATE})			   > $Z
			    echo "$STAMP" "error sending viamail" >> $Z
			    cat $Z >> /var/tmp/mail-server.log

			    $MHMAIL "$FROM" \
				-subject "Re: $SUBJECT ($directive)" \
				-from "$PERSON" -cc "$PERSON" \
				-body "error sending viamail"
			fi
		    else
			echo "\
To: $FROM
Subject: Re: $SUBJECT ($directive)
From: $PERSON

#text/plain [] $P
" > $F/$N
			if mhdraft=$F/$N $MHN $F/$N; then
			    if $SEND -draftf +$F -draftm $N -split 180; then
				true
			    else
				(eval ${DATE})				 > $Z
				echo "$STAMP" "error sending draft"	>> $Z
				cat $Z >> /var/tmp/mail-server.log

				$MHMAIL "$FROM" \
				    -subject "Re: $SUBJECT ($directive)" \
				    -from "$PERSON" -cc "$PERSON" \
				    -body "error sending draft"
			    fi
			else
			    (eval ${DATE})				 > $Z
			    echo "$STAMP" "error generating draft"	>> $Z
			    cat $Z >> /var/tmp/mail-server.log

			    $MHMAIL "$FROM" \
				-subject "Re: $SUBJECT ($directive)" \
				-from "$PERSON" -cc "$PERSON" \
				-body "error generating draft"
			fi
		    fi
		done
		continue
		;;

	dir)	if echo "$arg" | egrep -s "\.\./|^/"; then
		    (eval ${DATE})				 > $Z
		    echo "$STAMP" "$arg: invalid package"	>> $Z
		    cat $Z >> /var/tmp/mail-server.log

		    $MHMAIL "$FROM" -subject "Re: $SUBJECT ($directive)" \
			-from "$PERSON" -cc "$PERSON" \
			-body "$arg: invalid package"
		else
		    /bin/ls -alg $arg | \
		        $MHMAIL "$FROM" -subject "Re: $SUBJECT ($directive)" \
			    -from "$PERSON"
		    continue
		fi
		;;

	help)	if [ -s Help ]; then
		    $MHMAIL "$FROM" -subject "Re: $SUBJECT ($directive)" \
			-from "$PERSON" < Help
		else
		    (eval ${DATE})					 > $Z
		    echo "$STAMP" "no help available, please try later" >> $Z
		    cat $Z >> /var/tmp/mail-server.log

		    $MHMAIL "$FROM" -subject "Re: $SUBJECT ($directive)" \
			-from "$PERSON" -cc "$PERSON" \
			-body "no help available, please try later"
		fi
		continue
		;;

	exit|end)
		;;

	*)	(eval ${DATE})					 > $Z
		echo "$STAMP" "invalid directive: $directive"	>> $Z
		cat $Z >> /var/tmp/mail-server.log

		$MHMAIL "$FROM" -subject "Re: $SUBJECT ($directive)" \
			-from "$PERSON" -cc "$PERSON" \
			-body "invalid directive: $directive"
		;;
    esac
    break
done

(eval ${DATE})					 > $Z
echo "$STAMP" DONE				>> $Z
cat $Z >> /var/tmp/mail-server.log

exit 0
