/*	/master/contrib/hylafax/faxd/Class20.c++,v 1.1.1.1 1995/11/30 03:32:20 polk Exp */
/*
 * Copyright (c) 1994-1995 Sam Leffler
 * Copyright (c) 1994-1995 Silicon Graphics, Inc.
 * HylaFAX is a trademark of Silicon Graphics
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#include "Class20.h"
#include "ModemConfig.h"

#include <stdlib.h>
#include <ctype.h>

Class20Modem::Class20Modem(FaxServer& s, const ModemConfig& c) : Class2Modem(s,c)
{
    serviceType = SERVICE_CLASS20;
    setupDefault(classCmd,	conf.class2Cmd,		"AT+FCLASS=2.0");
    setupDefault(mfrQueryCmd,	conf.mfrQueryCmd,	"AT+FMI?");
    setupDefault(modelQueryCmd,	conf.modelQueryCmd,	"AT+FMM?");
    setupDefault(revQueryCmd,	conf.revQueryCmd,	"AT+FMR?");
    setupDefault(dccQueryCmd,	conf.class2DCCQueryCmd, "AT+FCC=?");
    setupDefault(abortCmd,	conf.class2AbortCmd,	"AT+FKS");

    setupDefault(borCmd,	conf.class2BORCmd,	"AT+FBO=0");
    setupDefault(tbcCmd,	conf.class2TBCCmd,	"AT+FPP=0");
    setupDefault(crCmd,		conf.class2CRCmd,	"AT+FCR=1");
    setupDefault(phctoCmd,	conf.class2PHCTOCmd,	"AT+FCT=30");
    setupDefault(bugCmd,	conf.class2BUGCmd,	"AT+FBU=1");
    setupDefault(lidCmd,	conf.class2LIDCmd,	"AT+FLI");
    setupDefault(dccCmd,	conf.class2DCCCmd,	"AT+FCC");
    setupDefault(disCmd,	conf.class2DISCmd,	"AT+FIS");
    setupDefault(cigCmd,	conf.class2CIGCmd,	"AT+FPI");
    setupDefault(splCmd,	conf.class2SPLCmd,	"AT+FSP");
    setupDefault(ptsCmd,	conf.class2PTSCmd,	"AT+FPS");

    setupDefault(noFlowCmd,	conf.class2NFLOCmd,	"AT+FLO=0");
    setupDefault(softFlowCmd,	conf.class2SFLOCmd,	"AT+FLO=1");
    setupDefault(hardFlowCmd,	conf.class2HFLOCmd,	"AT+FLO=2");

    // ignore procedure interrupts
    setupDefault(pieCmd,	conf.class2PIECmd,	"AT+FIE=0");
    // enable reporting of everything
    setupDefault(nrCmd,		conf.class2NRCmd,	"AT+FNR=1,1,1,1");
}

Class20Modem::~Class20Modem()
{
}

ATResponse
Class20Modem::atResponse(char* buf, long ms)
{
    if (FaxModem::atResponse(buf, ms) == AT_OTHER &&
      (buf[0] == '+' && buf[1] == 'F')) {
	if (strneq(buf, "+FHS:", 5)) {
	    processHangup(buf+5);
	    lastResponse = AT_FHNG;
	    hadHangup = TRUE;
	} else if (strneq(buf, "+FCO", 4))
	    lastResponse = AT_FCON;
	else if (strneq(buf, "+FPO", 4))
	    lastResponse = AT_FPOLL;
	else if (strneq(buf, "+FVO", 4))
	    lastResponse = AT_FVO;
	else if (strneq(buf, "+FIS:", 5))
	    lastResponse = AT_FDIS;
	else if (strneq(buf, "+FNF:", 5))
	    lastResponse = AT_FNSF;
	else if (strneq(buf, "+FCI:", 5))
	    lastResponse = AT_FCSI;
	else if (strneq(buf, "+FPS:", 5))
	    lastResponse = AT_FPTS;
	else if (strneq(buf, "+FCS:", 5))
	    lastResponse = AT_FDCS;
	else if (strneq(buf, "+FNS:", 5))
	    lastResponse = AT_FNSS;
	else if (strneq(buf, "+FTI:", 5))
	    lastResponse = AT_FTSI;
	else if (strneq(buf, "+FET:", 5))
	    lastResponse = AT_FET;
    }
    return (lastResponse);
}

/*
 * Abort a data transfer in progress.
 */
void
Class20Modem::abortDataTransfer()
{
    char c = CAN;
    putModemData(&c, 1);
}

/*
 * Send a page of data using the ``stream interface''.
 */
fxBool
Class20Modem::sendPage(TIFF* tif)
{
    fxBool rc = TRUE;
    protoTrace("SEND begin page");
    if (flowControl == FLOW_XONXOFF)
	setXONXOFF(FLOW_XONXOFF, FLOW_NONE, ACT_FLUSH);
    /*
     * Correct bit order of data if not what modem expects.
     */
    uint16 fillorder;
    TIFFGetFieldDefaulted(tif, TIFFTAG_FILLORDER, &fillorder);
    const u_char* bitrev = TIFFGetBitRevTable(fillorder != conf.sendFillOrder);

    fxBool firstStrip = setupTagLineSlop(params);
    u_int ts = getTagLineSlop();
    uint32* stripbytecount;
    (void) TIFFGetField(tif, TIFFTAG_STRIPBYTECOUNTS, &stripbytecount);
    for (tstrip_t strip = 0; strip < TIFFNumberOfStrips(tif) && rc; strip++) {
	uint32 totbytes = stripbytecount[strip];
	if (totbytes > 0) {
	    u_char* data = new u_char[totbytes+ts];
	    if (TIFFReadRawStrip(tif, strip, data+ts, totbytes) >= 0) {
		u_char* dp;
		if (firstStrip) {
		    /*
		     * Generate tag line at the top of the page.
		     */
		    dp = imageTagLine(data, fillorder, params);
		    totbytes = totbytes+ts - (dp-data);
		    firstStrip = FALSE;
		} else
		    dp = data;
		/*
		 * Pass data to modem, filtering DLE's and
		 * being careful not to get hung up.
		 */
		beginTimedTransfer();
		rc = putModemDLEData(dp, (u_int) totbytes, bitrev,
		    getDataTimeout());
		endTimedTransfer();
		protoTrace("SENT %u bytes of data", totbytes);
	    }
	    delete data;
	}
    }
    if (!rc)
	abortDataTransfer();
    else
	rc = sendRTC(params.is2D());
    if (flowControl == FLOW_XONXOFF)
	setXONXOFF(getInputFlow(), FLOW_XONXOFF, ACT_DRAIN);
    protoTrace("SEND end page");
    return (rc);
}

/*
 * Handle the page-end protocol.  Since Class 2.0 returns
 * OK/ERROR according to the post-page response, we don't
 * need to query the modem to get the actual code and
 * instead synthesize codes, ignoring whether or not the
 * modem does retraining on the next page transfer.
 */
fxBool
Class20Modem::pageDone(u_int ppm, u_int& ppr)
{
    static char ppmCodes[3] = { 0x2C, 0x3B, 0x2E };
    char eop[2];

    eop[0] = DLE;
    eop[1] = ppmCodes[ppm];

    ppr = 0;					// something invalid
    if (putModemData(eop, sizeof (eop))) {
	for (;;) {
	    switch (atResponse(rbuf, conf.pageDoneTimeout)) {
	    case AT_FHNG:
		if (!isNormalHangup())
		    return (FALSE);
		/* fall thru... */
	    case AT_OK:				// page data good
		ppr = PPR_MCF;			// could be PPR_RTP/PPR_PIP
		return (TRUE);
	    case AT_ERROR:			// page data bad
		ppr = PPR_RTN;			// could be PPR_PIN
		return (TRUE);
	    case AT_EMPTYLINE:
	    case AT_TIMEOUT:
	    case AT_NOCARRIER:
	    case AT_NODIALTONE:
	    case AT_NOANSWER:
		goto bad;
	    }
	}
    }
bad:
    processHangup("50");			// Unspecified Phase D error
    return (FALSE);
}

/*
 * Class 2.0 must override the default behaviour used
 * Class 1+2 modems in order to do special handling of
 * <DLE><SUB> escape (translate to <DLE><DLE>).
 */
int
Class20Modem::decodeNextByte()
{
    int b = getModemDataChar();
    if (b == EOF)
	raiseEOF();
    if (b == DLE) {
	switch (b = getModemDataChar()) {
	case EOF: raiseEOF();
	case ETX: raiseRTC();		// RTC
	case DLE: break;		// <DLE><DLE> -> <DLE>
	case SUB: b = DLE;		// <DLE><SUB> -> <DLE><DLE>
	    /* fall thru... */
	default:
	    setPendingByte(b);
	    b = DLE;
	    break;
	}
    }
    return (b);
}
