static char rcsid[] = "buffer.c,v 1.1.1.1 1995/12/11 07:26:38 ewv Exp";
/*
 *  buffer.c - Simple dynamic buffer management.
 *
 *  Darren Hardy, hardy@cs.colorado.edu, February 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder. 
 *  
 *  This copyright notice applies to all code in Harvest other than
 *  subsystems developed elsewhere, which contain other copyright notices
 *  in their source text.
 *  
 *  The Harvest software was developed by the Internet Research Task
 *  Force Research Group on Resource Discovery (IRTF-RD).  The Harvest
 *  software may be used for academic, research, government, and internal
 *  business purposes without charge.  If you wish to sell or distribute
 *  the Harvest software to commercial clients or partners, you must
 *  license the software.  See
 *  http://harvest.cs.colorado.edu/harvest/copyright,licensing.html#licensing.
 *  
 *  The Harvest software is provided ``as is'', without express or
 *  implied warranty, and with no support nor obligation to assist in its
 *  use, correction, modification or enhancement.  We assume no liability
 *  with respect to the infringement of copyrights, trade secrets, or any
 *  patents, and are not responsible for consequential damages.  Proper
 *  use of the Harvest software is entirely the responsibility of the user.
 *  
 *  For those who are using Harvest for non-commercial purposes, you may
 *  make derivative works, subject to the following constraints:
 *  
 *  - You must include the above copyright notice and these accompanying 
 *    paragraphs in all forms of derivative works, and any documentation 
 *    and other materials related to such distribution and use acknowledge 
 *    that the software was developed at the above institutions.
 *  
 *  - You must notify IRTF-RD regarding your distribution of the 
 *    derivative work.
 *  
 *  - You must clearly notify users that your are distributing a modified 
 *    version and not the original Harvest software.
 *  
 *  - Any derivative product is also subject to the restrictions of the 
 *    copyright, including distribution and use limitations.
 */
#include <stdio.h>
#include <string.h>
#include "util.h"

/*
 *  create_buffer() - Creates a buffer of default_size bytes allocated.
 */
Buffer *create_buffer(default_size)
int default_size;
{
	static Buffer *b = NULL;

	b = xmalloc(sizeof(Buffer));
	b->size = b->default_size = default_size;
	b->data = xmalloc(b->size);
	b->length = 0;
#ifdef DEBUG
	log("Creating buffer of %d bytes\n", b->size);
#endif
	return (b);
}

/*
 *  increase_buffer() - Increase the buffer so that it holds sz more bytes.
 */
void increase_buffer(b, sz)
Buffer *b;
int sz;
{
	b->size += sz;
	b->data = xrealloc(b->data, b->size);
#ifdef DEBUG
	log("Growing buffer by %d bytes to %d bytes\n", sz, b->size);
#endif
}

/*
 *  grow_buffer() - increases the buffer size by the default size
 */
void grow_buffer(b)
Buffer *b;
{
	increase_buffer(b, b->default_size);
}

/*
 *  shrink_buffer() - restores a buffer back to its original size.
 *  all data is lost.
 */
void shrink_buffer(b)
Buffer *b;
{
	b->length = 0;
	if (b->size == b->default_size)		/* nothing to do */
		return;

	if (b->data)
		xfree(b->data);
	b->size = b->default_size;
	b->data = xmalloc(b->size);
#ifdef DEBUG
	log("Shrinking buffer to %d bytes\n", b->size);
#endif
}

/*
 *  free_buffer() - Cleans up after a buffer.
 */
void free_buffer(b)
Buffer *b;
{
	if (b == NULL)
		return;
#ifdef DEBUG
	log("Freeing buffer of %d bytes\n", b->size);
#endif
	if (b->data)
		xfree(b->data);
	xfree(b);
}


/*
 *  add_buffer() - Adds the sz bytes of s to the Buffer b.
 */
void add_buffer(b, s, sz)
Buffer *b;
char *s;
int sz;
{
	if (sz < 1)
		return;
	if (b->length + sz + 1 > b->size)
		increase_buffer(b, sz);
	if (sz > 1)
		memcpy(&b->data[b->length], s, sz);
	else
		b->data[b->length] = *s;
	b->length += sz;
	b->data[b->length] = '\0';	/* add NULL to current position */
}
