
static char rcsid[] = "@(#)find_alias.c,v 1.1.1.1 1995/11/14 20:01:37 bostic Exp";

/*******************************************************************************
 *  The Elm Mail System  -  1.1.1.1   Exp
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Syd Weinstein, Elm Coordinator
 *	elm@DSI.COM			dsinc!elm
 *
 *******************************************************************************
 * find_alias.c,v
 * Revision 1.1.1.1  1995/11/14 20:01:37  bostic
 * Elm 2.4PL24
 *
 * Revision 5.1  1992/10/03  22:58:40  syd
 * Initial checkin as of 2.4 Release at PL0
 *
 *
 ******************************************************************************/

/** 
	Search the list of aliases for a specific address.  Search
	is limited to either SYSTEM or USER alias types....
**/

#include "headers.h"

extern int num_duplicates;

int
find_alias(word, alias_type)
char *word;
int alias_type;
{
	/** find word and return loc, or -1 **/
	register int loc = -1;

	/** cannot be an alias if its longer than NLEN chars **/
	if (strlen(word) > NLEN)
	    return(-1);

	while (++loc < (message_count+num_duplicates)) {
	    if ( aliases[loc]->type & alias_type ) {
	        if (istrcmp(word, aliases[loc]->alias) == 0)
	            return(loc);
	    }
	}

	return(-1);				/* Not found */
}
