static char rcsid[] = "@(#)shiftlower.c,v 1.1.1.1 1995/11/14 20:01:31 bostic Exp";

/*******************************************************************************
 *  The Elm Mail System  -  1.1.1.1   Exp
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Syd Weinstein, Elm Coordinator
 *	elm@DSI.COM			dsinc!elm
 *
 *******************************************************************************
 * shiftlower.c,v
 * Revision 1.1.1.1  1995/11/14 20:01:31  bostic
 * Elm 2.4PL24
 *
 * Revision 5.3  1994/03/11  22:11:09  syd
 * There is a bug in the alias-system of elm-2.4.23 that did not appear in
 * elm-2.4.21. When searching for a string in the alias-table with the '//'
 * command, elm sometimes gets a segmentation fault. With help of a debugger,
 * I found that the function shift_lower gets a NULL argument. A fix is
 * appended, but maybe the problem lies elsewhere.
 * From: Sjaak Schilperoort <J.W.Schilperoort@research.ptt.nl>
 *
 * Revision 5.2  1993/08/03  19:28:39  syd
 * Elm tries to replace the system toupper() and tolower() on current
 * BSD systems, which is unnecessary.  Even worse, the replacements
 * collide during linking with routines in isctype.o.  This patch adds
 * a Configure test to determine whether replacements are really needed
 * (BROKE_CTYPE definition).  The <ctype.h> header file is now included
 * globally through hdrs/defs.h and the BROKE_CTYPE patchup is handled
 * there.  Inclusion of <ctype.h> was removed from *all* the individual
 * files, and the toupper() and tolower() routines in lib/opt_utils.c
 * were dropped.
 * From: chip@chinacat.unicom.com (Chip Rosenthal)
 *
 * Revision 5.1  1992/10/03  22:41:36  syd
 * Initial checkin as of 2.4 Release at PL0
 *
 *
 ******************************************************************************/

/** 

**/

#include "headers.h"

char *shift_lower(string)
char *string;
{
	/** return 'string' shifted to lower case.  Do NOT touch the
	    actual string handed to us! **/

	static char buffer[VERY_LONG_STRING];
	register char *bufptr = buffer;

	if (string == NULL) {
		buffer[0] = 0;
		return( (char *) buffer);
	}
	for (; *string; string++, bufptr++)
	  *bufptr = tolower(*string);
	
	*bufptr = 0;
	
	return( (char *) buffer);
}
