/*
 * Copyright (c) 1993 David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 */


#ifndef	FUNC_H
#define	FUNC_H

#include "calc.h"
#include "label.h"


/*
 * Structure of a function.
 * The f_opcodes array is actually of variable size.
 */
typedef struct func FUNC;
struct func {
	FUNC *f_next;			/* next function in list */
	unsigned long f_opcodecount;	/* size of opcode array */
	unsigned int f_localcount;	/* number of local variables */
	unsigned int f_paramcount;	/* max number of parameters */
	char *f_name;			/* function name */
	VALUE f_savedvalue;		/* saved value of last expression */
	unsigned long f_opcodes[1];	/* array of opcodes (variable length) */
};


/*
 * Amount of space needed to allocate a function of n opcodes.
 */
#define funcsize(n) (sizeof(FUNC) + (n) * sizeof(long))


/*
 * Size of a character pointer rounded up to a number of opcodes.
 */
#define PTR_SIZE ((sizeof(char *) + sizeof(long) - 1) / sizeof(long))


/*
 * The current function being compiled.
 */
extern FUNC *curfunc;


/*
 * Functions to handle functions.
 */
extern FUNC *findfunc PROTO((long index));
extern char *namefunc PROTO((long index));
extern BOOL evaluate PROTO((BOOL nestflag));
extern long adduserfunc PROTO((char *name));
extern void beginfunc PROTO((char *name, BOOL newflag));
extern int builtinopcode PROTO((long index));
extern char *builtinname PROTO((long index));
extern int dumpop PROTO((unsigned long *pc));
extern void addop PROTO((long op));
extern void endfunc PROTO((void));
extern void addopone PROTO((long op, long arg));
extern void addoptwo PROTO((long op, long arg1, long arg2));
extern void addoplabel PROTO((long op, LABEL *label));
extern void addopptr PROTO((long op, char *ptr));
extern void writeindexop PROTO((void));
extern void showbuiltins PROTO((void));
extern int getbuiltinfunc PROTO((char *name));
extern void builtincheck PROTO((long index, int count));
extern void addopfunction PROTO((long op, long index, int count));
extern void showfunctions PROTO((void));
extern void initfunctions PROTO((void));
extern void clearopt PROTO((void));
extern void updateoldvalue PROTO((FUNC *fp));
extern void calculate PROTO((FUNC *fp, int argcount));
extern VALUE builtinfunc PROTO((long index, int argcount, VALUE *stck));

#endif

/* END CODE */
