/*
 * Copyright (c) 1994 David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 *
 * Definitions for calculator program.
 */

#ifndef	CALC_H
#define	CALC_H


#include <stdio.h>
#include <setjmp.h>
#include "value.h"


/*
 * Configuration definitions
 */
#define	CALCPATH	"CALCPATH"	/* environment variable for files */
#define	CALCRC		"CALCRC"	/* environment variable for startup */
#define	CALCBINDINGS	"CALCBINDINGS"	/* environment variable for hist bindings */
#define	HOME		"HOME"		/* environment variable for home dir */
#define	PAGER		"PAGER"		/* environment variable for help */
#define	SHELL		"SHELL"		/* environment variable for shell */
#define DEFAULTCALCHELP	"help"		/* help file that -h prints */
#define DEFAULTSHELL	"sh"		/* default shell to use */
#define	CALCEXT		".cal"	/* extension for files read in */
#define	PATHSIZE	1024	/* maximum length of path name */
#define	HOMECHAR	'~'	/* char which indicates home directory */
#define DOTCHAR		'.'	/* char which indicates current directory */
#define	PATHCHAR	'/'	/* char which separates path components */
#define	LISTCHAR	':'	/* char which separates paths in a list */
#define	MAXCMD		16384	/* maximum length of command invocation */
#define	MAXERROR	512	/* maximum length of error message string */

#define	SYMBOLSIZE	256	/* maximum symbol name size */
#define	MAXINDICES	20	/* maximum number of indices for objects */
#define	MAXLABELS	100	/* maximum number of user labels in function */
#define	MAXOBJECTS	10	/* maximum number of object types */
#define	MAXSTRING	1024	/* maximum size of string constant */
#define	MAXSTACK	1000	/* maximum depth of evaluation stack */
#define	MAXFILES	20	/* maximum number of opened files */
#define PROMPT1		"> "	/* default normal prompt*/
#define PROMPT2		">> "	/* default prompt inside multi-line input */


#define	TRACE_NORMAL	0x00	/* normal trace flags */
#define	TRACE_OPCODES	0x01	/* trace every opcode */
#define	TRACE_NODEBUG	0x02	/* suppress debugging opcodes */
#define	TRACE_MAX	0x03	/* maximum value for trace flag */

#define DISPLAY_DEFAULT 20	/* default digits for float display */
#define EPSILON_DEFAULT "1e-20"	/* allowed error for float calculations */
#define EPSILONPREC_DEFAULT 67	/* 67 ==> 2^-67 <= EPSILON_DEFAULT < 2^-66 */
#define NEW_EPSILON_DEFAULT "1e-10"	/* newstd EPSILON_DEFAULT */
#define NEW_EPSILONPREC_DEFAULT 34	/* 34 ==> 2^-34 <= 1e-10 < 2^-33 */
#define MAXPRINT_DEFAULT 16	/* default number of elements printed */
#define MAXERRORCOUNT 20	/* default max errors before an abort */

#define ABORT_NONE	0	/* abort not needed yet */
#define ABORT_STATEMENT	1	/* abort on statement boundary */
#define ABORT_OPCODE	2	/* abort on any opcode boundary */
#define ABORT_MATH	3	/* abort on any math operation */
#define ABORT_NOW	4	/* abort right away */

/*
 * File ids corresponding to standard in, out, error, and when not in use.
 */
#define	FILEID_STDIN	((FILEID) 0)
#define	FILEID_STDOUT	((FILEID) 1)
#define	FILEID_STDERR	((FILEID) 2)
#define	FILEID_NONE	((FILEID) -1)

/*
 * File I/O routines.
 */
extern FILEID openid PROTO((char *name, char *mode));
extern FILEID indexid PROTO((long index));
extern BOOL validid PROTO((FILEID id));
extern BOOL errorid PROTO((FILEID id));
extern BOOL eofid PROTO((FILEID id));
extern BOOL closeid PROTO((FILEID id));
extern int getcharid PROTO((FILEID id));
extern void idprintf PROTO((FILEID id, char *fmt, int count, VALUE **vals));
extern void idfputc PROTO((FILEID id, int ch));
extern void idfputs PROTO((FILEID id, char *str));
extern void printid PROTO((FILEID id, int flags));
extern void flushid PROTO((FILEID id));
extern void readid PROTO((FILEID id, int remove_nl, char **retptr));
extern int getloc PROTO((FILEID id, ZVALUE *loc));
extern int setloc PROTO((FILEID id, ZVALUE zpos));
extern int getsize PROTO((FILEID id, ZVALUE *size));
extern int get_device PROTO((FILEID id, ZVALUE *dev));
extern int get_inode PROTO((FILEID id, ZVALUE *ino));


/*
 * Input routines.
 */
extern FILE *f_open PROTO((char *name, char *mode));
extern int openstring PROTO((char *str));
extern int openterminal PROTO((void));
extern int opensearchfile PROTO((char *name, char *pathlist, char *exten, int reopen_ok));
extern char *nextline PROTO((void));
extern int nextchar PROTO((void));
extern void reread PROTO((void));
extern void resetinput PROTO((void));
extern void setprompt PROTO((char *));
extern BOOL inputisterminal PROTO((void));
extern char *inputname PROTO((void));
extern long linenumber PROTO((void));
extern void runrcfiles PROTO((void));
extern void closeinput PROTO((void));
extern FILE *curstream PROTO((void));


/*
 * Other routines.
 */
extern NUMBER *constvalue PROTO((unsigned long index));
extern long addnumber PROTO((char *str));
extern long addqconstant PROTO((NUMBER *q));
extern void initstack PROTO((void));
extern void version PROTO((FILE *stream));
extern void getcommands PROTO((BOOL toplevel));
extern void givehelp PROTO((char *type));
extern void hash_init PROTO((void));


/*
 * Global data definitions.
 */
extern int abortlevel;		/* current level of aborts */
extern BOOL inputwait;		/* TRUE if in a terminal input wait */
extern VALUE *stack;		/* execution stack */
extern jmp_buf jmpbuf;		/* for errors */
extern int start_done;		/* TRUE => start up processing finished */

extern char *calcpath;		/* $CALCPATH or default */
extern char *calcrc;		/* $CALCRC or default */
extern char *calcbindings;	/* $CALCBINDINGS or default */
extern char *home;		/* $HOME or default */
extern char *shell;		/* $SHELL or default */

extern int allow_read;	/* FALSE => may not open any files for reading */
extern int allow_write;	/* FALSE => may not open any files for writing */
extern int allow_exec;	/* FALSE => may not execute any commands */

extern int post_init;	/* TRUE => setjmp for math_error is ready */

#endif

/* END CODE */
