/*	BSDI	rfc931.c,v 1.2 1995/12/06 04:25:14 sanders Exp */

/* ====================================================================
 * Copyright (c) 1995 The Apache Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * 4. The names "Apache Server" and "Apache Group" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * IT'S CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Group and was originally based
 * on public domain software written at the National Center for
 * Supercomputing Applications, University of Illinois, Urbana-Champaign.
 * For more information on the Apache Group and the Apache HTTP server
 * project, please see <http://www.apache.org/>.
 *
 */

/*
 * rfc931() speaks a common subset of the RFC 931, AUTH, TAP and IDENT
 * protocols. The code queries an RFC 931 etc. compatible daemon on a remote
 * host to look up the owner of a connection. The information should not be
 * used for authentication purposes. This routine intercepts alarm signals.
 * 
 * Author: Wietse Venema, Eindhoven University of Technology,
 * The Netherlands.
 * Modified: Tony Sanders <sanders@earth.com>, September 15, 1995
 */

#include "conf.h"

#ifdef NOTDEF			/* Has changed a lot since this... */
static char sccsid[] = "@(#) rfc931.c 1.8 93/12/13 22:23:20";
#endif

/* System libraries. */

#include <stdio.h>
#ifndef NEXT
#include <unistd.h>
#endif
#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#ifndef ULTRIX_BRAIN_DEATH
#include <sys/socket.h>
#endif
#include <netinet/in.h>

#define RFC931_TIMEOUT	500		/* default timeout (seconds) */
#define	RFC931_PORT	113		/* Semi-well-known port */
#define	RFC931_BUFLEN	512		/* must hold `%u , %u\r\n\0' */

int rfc931_timeout = RFC931_TIMEOUT;		/* exported symbol */
static char *rfc931_unknown = "unknown";	/* unknown result */
static jmp_buf rfc931_jmpbuf;			/* timeout handler */

/* timeout -- handles SIGALRM */
static void
alarm_timeout(int sig)
{
    longjmp(rfc931_jmpbuf, sig);
}

/* rfc921 -- returns the remote user name */
char *
rfc931(struct sockaddr_in *remote_sin, struct sockaddr_in *local_sin)
{
    int s;
    struct sockaddr_in remote_query_sin;
    struct sockaddr_in local_query_sin;
    unsigned remote_port;
    unsigned local_port;
    char buffer[RFC931_BUFLEN];
    char scanbuf[80];				/* small sscanf fmt string */
    static char user[RFC931_BUFLEN];		/* XXX: static buffer */
    char *result;

    result = rfc931_unknown;

    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	return result;

    /* Set up timer so we won't get stuck while waiting for the server */
    if (setjmp(rfc931_jmpbuf) == 0) {
	signal(SIGALRM, alarm_timeout);
	alarm(rfc931_timeout);

	/*
	 * Bind the local and remote ends of the query socket to the same
	 * IP addresses as the connection under investigation. We go
	 * through all this trouble because the local or remote system
	 * might have more than one network address. The RFC931 etc.
	 * client sends only port numbers; the server takes the IP
	 * addresses from the query socket.
	 */

	local_query_sin = *local_sin;
	local_query_sin.sin_port = htons(0);
	remote_query_sin = *remote_sin;
	remote_query_sin.sin_port = htons(RFC931_PORT);

	if (bind(s, (struct sockaddr *)&local_query_sin,
		    sizeof(local_query_sin)) < 0)
	    return result;

        if (connect(s, (struct sockaddr *)&remote_query_sin,
		    sizeof(local_query_sin)) < 0)
	    return result;

	/* Send query to server */
	sprintf(buffer, "%u , %u\r\n",
		ntohs(remote_sin->sin_port),
		ntohs(local_sin->sin_port));
	if (write(s, buffer, strlen(buffer)) == -1)
	    return result;

	/* Read response from server */
	if (read(s, buffer, RFC931_BUFLEN-1) == -1)
	    return result;

	/* all done with network -- disable timeout alarm */
	alarm(0);

	/*
	 * Return data format is:
	 *     lport , rport : reply_type : opsys_or_error : identifier
	 *
	 * "%d , %d : %[^ \t\r\n:] : %[^\t\r\n:] : %[^\r\n]"
	 */

	sprintf(scanbuf, "%%u , %%u : USERID : %%*[^\t\r\n:] : %%%d[^\r\n]",
	    RFC931_BUFLEN-1);
	if (sscanf(buffer, scanbuf, &remote_port, &local_port, user) != 3)
	    return result;

	/* sanity check port numbers */
	if ((ntohs(remote_sin->sin_port) != remote_port)
		    || (ntohs(local_sin->sin_port) != local_port))
	    return result;

	result = user;
    }

    return result;
}
