/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991,1994 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */

/*
 * amdump.sh - manage one night's Amanda dump run.
 */
#include "config.h"
#include "options.h"
#include "version.h"

/* try to hit all the possibilities here */
PATH=LIBEXEC_DIR
PATH=$PATH:/usr/bin:/usr/ucb:/usr/sbin:/bin:/sbin
export PATH
confdir=CONFIG_DIR
execdir=LIBEXEC_DIR

#ifdef USE_VERSION_SUFFIXES
suf=VERSION_SUFFIX
#else
suf=
#endif

if [ $# -ne 1 ]; then
        echo  Usage: amdump conf
        exit 1
fi

conf=$1
if [ ! -d $confdir/$conf ]; then
    echo "amdump: could not find directory $confdir/$conf"
    exit 1
fi

cd $confdir/$conf
logfile=`getconf$suf logfile`
errfile=`dirname $logfile`/amdump
tapecycle=`getconf$suf tapecycle`
dumpuser=`getconf$suf dumpuser`
runuser=`whoami`

if [ $runuser != $dumpuser ]; then
	echo "amdump: must be run as user $dumpuser"
	exit 1
fi

exec </dev/null >$errfile 2>&1
$execdir/planner$suf | $execdir/driver$suf

exec </dev/null >/dev/null 2>&1
$execdir/reporter$suf

/* keep debug log through the tapecycle plus a couple days, up to 50 */
days=`expr $tapecycle + 2`

if [ $days -gt 50 ]; then
	days=50
fi

while [ $days -ge 2 ]; do
	ndays=`expr $days - 1`
	mv $errfile.$ndays $errfile.$days
	days=$ndays
done
mv $errfile $errfile.1

exit 0
