/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991,1994 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
/*
 * options.h - here is where site-specific but not OS or machine specific
 *	       options go.  The site administrator should customize these
 *	       to taste.
 */


/*
 * Directories where Amanda will reside.
 */
/*
 * CONFIG_DIR specifies where the runtime files are to be found.
 * Amanda supports multiple configurations per site; these are contained
 * in subdirectories of CONFIG_DIR.  Also:
 * 	BIN_DIR		- User visible program
 *	LIBEXEC_DIR	- Internal support programs
 *	MAN_DIR		- Man pages
 */
#define CONFIG_DIR "/etc/amanda"
#define LIBEXEC_DIR "/usr/contrib/lib/amanda"
#define BIN_DIR	"/usr/contrib/bin"
#define MAN_DIR	"/usr/contrib/man/man8"


/*
 * MK_CCOPTS contains any flags you might want to pass to the C compiler.
 * I compile with -g to compile in a full symbol table, but you might choose
 * to use -O or something else.
 */
#define MK_CCOPTS -O
/*
 * You can also redefine MK_CC here if you wish to override the system
 * dependent C compiler.  If you have a stable version of GCC, you may
 * well want to use that instead of the system compiler.
 */
#undef  MK_CC	
#define MK_CC shlicc


/*
 * With USE_VERSION_SUFFIXES defined, all the Amanda binaries will be
 * installed with a version string appended to the command name, for
 * example "amdump-2.2.1".  You must then set up symlinks from "amdump" to
 * the correct version of the binary, or use them with the version suffixes
 * directly.
 *
 * This is mostly useful when you want multiple versions online for testing
 * purposes.  I recommend it if you are doing a major version upgrade and
 * wish to try out the new version in parallel with the old.
 *
 * Since 2.2.1 is a major change, I recommend defining this for existing
 * Amanda sites.
 */
/* #define USE_VERSION_SUFFIXES */


/*
 * BSD_SECURITY selects BSD rsh/rlogin style security, which is not great,
 * but is in common use, and its strengths and weaknesses are well known.
 * Under BSD_SECURITY, the Amanda backup client hosts will check .rhosts
 * files before sending any dump data.
 */
#define BSD_SECURITY


/*
 * KRB4_SECURITY selects MIT Kerberos version 4 style security, which is
 * significantly better than BSD_SECURITY, providing for mutual
 * authentication and (optionally) encryption of backup data over the
 * network.  Both BSD_SECURITY and KRB4_SECURITY may be defined at the same
 * time: the type of security to be used can be selected on a per-client-host
 * basis (in the disklist file).
 *
 * NOTE: Due to stupid USA export restrictions, use of KRB4_SECURITY
 * requires source files from the separate "amanda-krb4" package.  See
 * the KERBEROS.HOW-TO-GET instructions on the Amanda home ftp site,
 * ftp.cs.umd.edu.
 */
/* #undef KRB4_SECURITY  -- This way we can define it from Makefile */

#ifdef KRB4_SECURITY
/*
 * If you turn on KRB4_SECURITY, you must set all these options below.
 *
 * You can set the principle, instance, and keyfile to use seperately for
 * both the client and server.
 *
 * The instance can either be a string constant, or `HOSTNAME_INSTANCE' if
 * you want the local hostname used as the instance (ala krb_get_phost).
 *
 * The keyfile name can be either a string constant, or `KEYFILE' to use the
 * default keyfile defined in <krb.h>.
 */
#  define SERVER_HOST_PRINCIPLE "amanda"
#  define SERVER_HOST_INSTANCE  HOSTNAME_INSTANCE
#  define SERVER_HOST_KEY_FILE  "/etc/amanda/krb_key"

#  define CLIENT_HOST_PRINCIPLE "rcmd"
#  define CLIENT_HOST_INSTANCE  HOSTNAME_INSTANCE
#  define CLIENT_HOST_KEY_FILE  KEYFILE

#  define TICKET_LIFETIME       128

/*
 * Add Kerberos include directories and libraries to the compiler command
 * line.  Customize these for your site.
 */
#  define MK_KRB4INC -I/usr/include/kerberosIV
#  define MK_KRB4LIB -lkrb -ldes

#endif /* KRB4_SECURITY */


/*
 * FORCE_USERID controls whether or not the Amanda client-side should suid
 * to a non-priveledged user when inetd runs it as root.  Most older inetds
 * do not allow you to specify which user to run a daemon as in inetd.conf;
 * all daemons are just run as root.
 *
 * We prefer to not do anything as root that can be done as a normal user,
 * so if FORCE_USERID is defined, Amanda will switch to the user specified
 * by CLIENT_LOGIN for all further operations on the slave host.  This type
 * of operation normally requires that the CLIENT_LOGIN be in some group
 * that has read permissions on the raw disk devices, and read/write perms
 * on /etc/dumpdates.

 */
#undef FORCE_USERID

#ifdef FORCE_USERID
#  define CLIENT_LOGIN	"bin"
#endif

/*
 * BUT NOTE: Ultrix dump _requires_ that it be run as root!
 */
#ifdef DUMP_NEEDS_ROOT
#  undef FORCE_USERID
#endif


/*
 * ASSERTIONS turns on assertion checking, which makes Amanda a bit bigger
 * and slower, but will help catch errors earlier.
 *
 * As this is a test release, you definitely want this turned on.
 */
#define ASSERTIONS


/*
 * HAVE_GZIP indicates that the gnu gzip program is installed at your site.
 * This is the preferred compression utility.  If you don't have it installed,
 * Amanda uses the system-installed "compress" utility.
 */
#define HAVE_GZIP

#ifdef HAVE_GZIP
#  define COMPRESS_PATH  	"/usr/contrib/bin/gzip"
#  define COMPRESS_SUFFIX 	".gz"
#  define COMPRESS_FAST_OPT	"--fast"
#  define COMPRESS_BEST_OPT	"--best"
#  define UNCOMPRESS_CMD	"gzcat"
#else
#  define COMPRESS_PATH		COMPRESS	/* defined in config.h */
#  define COMPRESS_SUFFIX	".Z"
#  define COMPRESS_FAST_OPT	"-f"		/* -f doesn't do anything */
#  define COMPRESS_BEST_OPT	"-f"		/* it's just a placeholder */
#  define UNCOMPRESS_CMD	"zcat"
#endif
