/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
/*
 * config.h-bsdi - OS and machine specific options for BSD, Inc.'s BSD/386 1.1.
 */

/*
 * Some system dependent pathnames.
 */
#define DEV_PREFIX  "/dev/"		/* /dev/disk/ on some systems */
#define RDEV_PREFIX "/dev/r"		/* /dev/rdisk/ on some systems */
#define DUMP "/sbin/dump"
#define COMPRESS "/usr/bin/compress"
#define MAILER "/usr/bin/mail"

/*
 * Some macros used by the Makefiles.  Customize for your system.
 */
#define MK_INSTALL 	install
#define MK_INSTFLAGS	-c -o bin
#define MK_CC		shlicc
#define MK_EXTRALIBS

/*
 * Amanda uses some ANSI C functions that are not yet universally available.
 * If your system does not have these routines, define the appropriate
 * NEED_ macro, and our own version will be substituted.
 */
#undef NEED_STRSTR			/* strstr() */
#undef NEED_STRERROR			/* strerror() */


/*
 * Define NEED_FLOCK if your system does not have the BSD-style flock() call
 * but does have SystemV-style lockf().
 */
#undef NEED_FLOCK


/*
 * Define NEED_REGEX if you don't have traditional BSD-style (and V7, I
 * think) re_comp() and re_exec(), or a compatible library.  The GNU regex
 * library supports this interface.  Just add the regex library in
 * MK_EXTRALIBS above if you have the GNU library.
 *
 * Otherwise, You'll need to select one of the following substitutes for
 * regular expression handling.  Add any needed entries to MK_EXTRALIBS for
 * extra libraries needed (eg "-lregex").
 */
#define NEED_REGEX

#ifdef NEED_REGEX
/* 
 * Support code is included for the following flavors of regex.  Select one.
 * N.B.  Not all of these have been well-tested.  Buyer-beware.
 *

 * regex-v8.o		regcomp(), regexec() and <regexp.h> as implemented
 * 			in Bell Lab's Unix V8, and reimplemented by Henry
 * 			Spencer.  BSD NET/2, and thus 386BSD and early
 * 			versions of BSDI's BSD/386 picked up this version.
 *
 * regex-sysv.o		regcmp() and regex() as present in System V.
 *
 * regex-posix.o	regcomp(), regexec() as defined by POSIX.2.  The Gnu
 *			regex library implements this, as does the latest
 *			versions of Henry Spencer's library.
 */
#define REGEX_FLAVOR	regex-posix.o

#endif


/*
 * Define STATFS_* depending on the type of statfs() call your operating
 * system supports.  See lib/statfs.c if you are not sure which flavor to
 * use.  Some of the flavors are:
 *	STATFS_BSD43	4.3 reno, 4.3 net/2, BSD 1.x, NetBSD 0.x, FreeBSD 1.x
 *	STATFS_BSD44	BSD 4.4, thus NetBSD 1.x, FreeBSD 2.x
 *	STATFS_VFS	SunOS and admirers
 *	STATFS_ULTRIX	Ultrix 4.x
 *	STATFS_OSF1	OSF OSF/1
 *	STATFS_SVR3	System V release 3
 *	STATFS_SVR4	System V release 4
 */
#define STATFS_BSD44


/*
 * Some systems don't have void, or don't handle it correctly.  If yours
 * is one of these, define BROKEN_VOID.
 */
#undef BROKEN_VOID


/*
 * Define NO_SETSOCKBUF if your system doesn't support the SO_SNDBUF and
 * SO_RCVBUF flavors of setsockopt().
 */
#undef NO_SETSOCKBUF


/* 
 * Define HAVE_SYSVSHM if your system supports the System V style
 * shared memory calls (shmget(), shmat(), etc).
 */
#undef HAVE_SYSVSHM


/* 
 * Define HAVE_MMAP if your system supports the Berkeley mmap() and munmap()
 * shared memory calls.
 */
#define HAVE_MMAP


/*
 * Define NO_NDBM if your system doesn't support the ndbm library routines.
 * Right now the master side requires ndbm for the info database, though
 * this will change in the future.
 * 
 * You can still build the slave side on systems without NDBM.
 */
#undef NO_NDBM


/*
 * Define NO_DIRENT if your system doesn't have the <dirent.h> and associated
 * library routines.  The master side requires <dirent.h> for amflush.
 *
 * An alternative location for <dirent.h> is <sys/dirent.h>.  Define
 * SYS_DIRENT if you do have the dirent routines but the header file is
 * <sys/dirent.h>.
 * 
 * You can still build the slave side on systems without DIRENT.
 */
#undef NO_DIRENT
#undef SYS_DIRENT


/*
 * Define DUMP_RETURNS_1 if you are running the Ultrix dump that exits
 * with 1 as a success code, rather than 0 like every other Unix
 * program in the world.  
 */
#undef DUMP_RETURNS_1

/*
 * Define DUMP_NEEDS_ROOT if you are running the Ultrix dump that
 * requires that it be run as root, rather than letting the sysadmin
 * control who runs dump via the disk device permissions.
 */
#undef DUMP_NEEDS_ROOT
