/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991, 1994 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
#include "amanda.h"

#undef isleap
#define isleap(y) ((((y) % 4) == 0 && ((y) % 100) != 0) || ((y) % 400) == 0)

time_t tm2time(tmp)
struct tm *tmp;
/*
 * Converts a struct tm to a time_t, assuming the following fields are valid: 
 *  tm_sec, tm_min, tm_hour, tm_mday, tm_mon, tm_year, tm_gmtoff
 * Also calculates and sets tm_yday from the year/month/mday fields.
 *
 * Not every OS has mktime() yet, so I rolled my own.  Unlike mktime()
 * however, this function assumes the input tm is normalized correctly, and
 * it uses the gmtoff rather than assuming localtime.  The formula is from
 * the POSIX.1 standard.  Also, this function takes a few microseconds,
 * compared with several milliseconds for the BSD version of mktime().
 * 
 * It looks like the POSIX formula breaks in 2100 (assume 64 bit time_t by
 * then, or it breaks a lot sooner), which isn't a leap year but will be
 * counted as one.
 */
{
#ifdef HAVE_MKTIME
    return mktime(tmp);
#else
    static int ydays[12] =	/* # days in year before month (0 == jan) */
	{  0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334 };

    tmp->tm_yday = ydays[tmp->tm_mon] + tmp->tm_mday-1;
    if(isleap(tmp->tm_year+1900) && tmp->tm_mon > 1) tmp->tm_yday += 1;

    return tmp->tm_sec + tmp->tm_min*60 + tmp->tm_hour*3600 +
	tmp->tm_yday*86400 + (tmp->tm_year-70)*31536000 +
	    ((tmp->tm_year-69)/4)*86400 - tmp->tm_gmtoff;
#endif
}


#ifdef TMTEST
main()
{
    time_t t1, t2;
    struct tm *tmp;
    int count, botches;

    srandom(time(0));

    count = botches = 0;
    for(t1 = 0; t1 < 2000000000; t1 += random()%20000) {
	count ++;
	t2 = tm2time(localtime(&t1));
	if(t1 == t2) continue;

	botches++;
	tmp = localtime(&t1);
	printf("%02d-%02d-%02d %02d:%02d:%02d t1 %10d t2 %10d diff %d\n",
	       tmp->tm_year < 100? tmp->tm_year : tmp->tm_year - 100, 
	       tmp->tm_mon+1, tmp->tm_mday,
	       tmp->tm_hour, tmp->tm_min, tmp->tm_sec, t1, t2, t2-t1);
    }
    printf("%d botches in %d attempts\n", botches, count);
}
#endif
