/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
/*
 * regex-v8.c	partially emulate re_comp() and re_exec() using V8-style
 *		regcomp() and regexec(), as found in Henry Spencer's regex
 *		library, used by BSD Net/2 derived systems.
 *
 *		This code doesn't address the difference between ed-style
 *		and egrep-style regular expressions.  Amanda doesn't use
 *		use fancy regexes, so is compatible with the least-common
 *		denominator systems.
 */
#include <regexp.h>

#define MAX_ERRSTR 80

#if __STDC__			/* blame the ANSI committee :-) */
#define CONST const
#else
#define CONST
#endif

regexp *re_regexp = 0;
char    re_errstr[MAX_ERRSTR];
int     re_goterror;

void regerror(s)
CONST char *s;
{
    strncpy(re_errstr, s, MAX_ERRSTR);
    re_errstr[MAX_ERRSTR-1] = '\0';	/* insure termination */
    re_goterror = 1;
}


char *re_comp(s)
char *s;
{
    /* returns NULL if string compiled correctly, an error message otherwise */

    if(re_regexp)
	free(re_regexp);

    re_goterror = 0;
    re_regexp = regcomp(s);
    if(re_goterror)
	return re_errstr;
    return 0;
}

int re_exec(s)
char *s;
{
    /* returns 1 if string matches last regexp, 0 if failed, -1 if error */
    int rc;

    re_goterror = 0;
    rc = regexec(re_regexp, s);
    if(re_goterror) 
	return -1;
    return rc;
}
