#!/usr/local/bin/wish -f

if {$argc != 1} {
    puts    stdout	"usage: showmime.tcl fileName"
    exit    1
}

set	bodyParts	""
set	fileName	[lindex $argv 0]
set	maxX		[expr [winfo screenwidth .]*5/12]
set	maxY		[expr [winfo screenheight .]*2/3]
set	nextX		0
set	nextY		0


proc	main	{w} {
    global	bodyParts fileName

    set		list		[exec mhn -list -file "$fileName"]
    set		lines		[split "$list" "\n"]

    frame	$w.frame	-borderwidth 10

    pack append	$w.frame	[label $w.frame.label \
					-font -*courier-medium-r-normal-*-120-* \
					-relief sunken \
					-text "part  type/subtype              size description                         "] \
				    {top fillx}
    catch { $w.frame.label configure -background lightskyblue }
    if {[set nline [expr [llength $lines]-1]] > 10} {
	pack append $w.frame	[scrollbar $w.frame.yscroll \
					-command "$w.frame.list yview" \
					-orient vertical \
					-relief sunken] \
				    {right filly}
	set	y	10
    } else {
	set	y	$nline
    }
    pack append $w.frame	[listbox $w.frame.list \
					-font -*courier-medium-r-normal-*-120-* \
					-geometry 73x$y \
					-relief sunken] \
			    {top expand}
    if {$nline > 10} {
	$w.frame.list configure	-yscroll "$w.frame.yscroll set"
    }
    catch { $w.frame.list configure -background lightskyblue }

    set		part		""
    for {set i 1; set j [llength $lines]} {$i<$j} {incr i} {
	set	line	[string range [lindex $lines $i] 5 end]
	if {[string index "$line" 0] != " "} {
	    set	part	[string range "$line" 0 \
				[expr [string first " " "$line"]-1]]
	}
	lappend	bodyParts	"$part"
	if {$i == 1} {
	    set	line	"all  [string range "$line" 5 end]"
	}
	$w.frame.list \
		insert	end	"$line"
    }

    bind	$w.frame.list	<1>	{%W select from [%W nearest %y]}
    bind	$w.frame.list	<B1-Motion>\
					{%W select to [%W nearest %y]}
    bind	$w.frame.list	<Shift-1> \
					{%W select adjust [%W nearest %y]}
    bind	$w.frame.list	<Shift-B1-Motion> \
					{%W select to [%W nearest %y]}
    bind	$w.frame.list	<Double-1> \
					"ShowCommand $w.frame.list"

    frame	$w.bot		-borderwidth 1
    pack append	$w.bot		[button $w.bot.button \
					-command "destroy ." \
					-text Dismiss] \
				    {top padx 5 pady 5 expand}

    pack append	.		$w.frame \
				    {top expand filly} \
				$w.bot \
				    {bottom fill}
}

proc	ShowCommand	{w} {
    global	bodyParts fileName maxX maxY nextX nextY

    foreach	i	[$w curselection] {
	if {[set part [lindex $bodyParts $i]] != ""} {
	    exec xterm	-geometry =80x20+$nextX+$nextY -e \
			mhn -cache always -form mhl.null -nolist -nopause -show -part "$part" -file "$fileName" &
	} else {
	    exec xterm	-geometry =80x20+$nextX+$nextY -e \
			mhn -cache always -form mhl.null -nolist -nopause -show -file "$fileName" &
	}
	if {[set nextX [expr $nextX+90]] > $maxX} {
	    set	nextX	0
	}
	if {[set nextY [expr $nextY+60]] > $maxY} {
	    set	nextY	0
	}
    }
    $w select clear
}

main ""
