/*	BSDI bsdi.h,v 1.3 1995/10/11 21:57:54 torek Exp	*/

/* s/ file for bsd386 system.  */

#include "bsd4-3.h"

#ifndef __bsdi__
#define __bsdi__ 1
#endif

#define DECLARE_GETPWUID_WITH_UID_T

#define SIGNALS_VIA_CHARACTERS

#define PENDING_OUTPUT_COUNT(FILE) ((FILE)->_p - (FILE)->_bf._base)
#define A_TEXT_OFFSET(x)    (sizeof (struct exec))
#define A_TEXT_SEEK(hdr) (N_TXTOFF(hdr) + A_TEXT_OFFSET(hdr))
#ifdef __i386__
#define	TEXT_START	0x1020	/* for QMAGIC */
#endif
#ifdef __sparc__
#define	TEXT_START	0x2020
#endif

#define	LINKER	ld
#define	LD_SWITCH_SYSTEM	-X

#define LIBS_DEBUG
#define LIB_X11_LIB -L/usr/X11R6/lib -lX11
#define LIBS_SYSTEM -lutil -lkvm -lcompat

#define HAVE_GETLOADAVG

#undef BSD_PGRPS

#define	HAVE_TERMIOS
#define	NO_TERMIO

/* The dumped Emacs records the timezone it was dumped in.  */
#define LOCALTIME_CACHE

/* System uses OXTABS instead of the expected TAB3.
   (Copied from netbsd.h.)  */
#define TABDLY OXTABS
#define TAB3 OXTABS

#define SYSV_SYSTEM_DIR

#define	START_FILES	pre-crt0.o /usr/lib/crt0.o

#define WAITTYPE int
/* get this since it won't be included if WAITTYPE is defined */
#ifdef emacs
#include <sys/wait.h>
#endif
#define WRETCODE(w) WEXITSTATUS(w)
#ifndef WCOREDUMP
#define WCOREDUMP(w) ((w) & 0200)
#endif
