.ad l
.nh
.TH quantize 9 "1 May 1994" "ImageMagick"
.SH NAME
Quantize - ImageMagick's color reduction algorithm.
.SH SYNOPSIS
.B #include <image.h>
.SH DESCRIPTION
This document describes how \fBImageMagick\fP performs color reduction on an
image.  To fully understand this document, you should have a knowledge
of basic imaging techniques and the tree data structure and terminology.
.PP
For purposes of color allocation, an image is a set of \fIn\fP pixels,
where each pixel is a point in RGB space.  RGB space is a 3-dimensional
vector space, and each pixel, \fIp\d\s-3i\s0\u\fP,  is defined by an
ordered triple of red, green, and blue coordinates, (\fIr\d\s-3i\s0\u,
g\d\s-3i\s0\u, b\d\s-3i\s0\u\fP).
.PP
Each primary color component (red, green, or blue) represents an
intensity which varies linearly from 0 to a maximum value,
\fIc\d\s-3max\s0\u\fP, which corresponds to full saturation of that
color.  Color allocation is defined over a domain consisting of the
cube in RGB space with opposite vertices at (0,0,0) and
(\fIc\d\s-3max\s0\u,c\d\s-3max\s0\u,c\d\s-3max\s0\u\fP).  \fBImageMagick\fP
requires \fIc\d\s-3max\s0\u = 255\fP.
.PP
The algorithm maps this domain onto a tree in which each node
represents a cube within that domain.  In the following discussion,
these cubes are defined by the coordinate of two opposite vertices: The
vertex nearest the origin in RGB space and the vertex farthest from the
origin.
.PP
The tree's root node represents the the entire domain, (0,0,0) through
(\fIc\d\s-3max\s0\u,c\d\s-3max\s0\u,c\d\s-3max\s0\u\fP).  Each lower level in
the tree is generated by subdividing one node's cube into eight smaller
cubes of equal size.  This corresponds to bisecting the parent cube
with planes passing through the midpoints of each edge.
.PP
The basic algorithm operates in three phases:  \fBClassification,
Reduction\fP, and \fBAssignment\fP.  \fBClassification\fP builds a
color description tree for the image.  \fBReduction\fP collapses the
tree until the number it represents, at most, is the number of colors
desired in the output image.  \fBAssignment\fP defines the output
image's color map and sets each pixel's color by reclassification in
the reduced tree. Our goal is to minimize the numerical discrepancies
between the original colors and quantized colors.  To learn more about
quantization error, see MEASURING COLOR REDUCTION ERROR later in this
document.
.PP
\fBClassification\fP begins by initializing a color description tree of
sufficient depth to represent each possible input color in a leaf.
However, it is impractical to generate a fully-formed color description
tree in the classification phase for realistic values of
\fIc\d\s-3max\s0\u\fP.  If color components in the input image are
quantized to \fIk\fP-bit precision, so that \fIc\d\s-3max\s0\u =
2\u\s-3k\s0\d-1\fP, the tree would need \fIk\fP levels below the root
node to allow representing each possible input color in a leaf.  This
becomes prohibitive because the tree's total number of nodes is
.PP
        \fI\s+6\(*S\u\s-9 k\d\di=1\s0 8k\fP\s0\u
.PP
A complete tree would require 19,173,961 nodes for \fIk = 8,
c\d\s-3max\s0\u = 255\fP.  Therefore, to avoid building a fully
populated tree, \fBImageMagick\fP: (1) Initializes data structures for
nodes only as they are needed; (2) Chooses a maximum depth for the tree
as a function of the desired number of colors in the output image
(currently \fIlog\d\s-34\s0\u(colormap size)\+2\fP).  A tree of this
depth generally allows the best representation of the source image with
the fastest computational speed and the least amount of memory.
However, the default depth is inappropriate for some images.
Therefore, the caller can request a specific tree depth.
.PP
For each pixel in the input image, classification scans downward from
the root of the color description tree.  At each level of the tree, it
identifies the single node which represents a cube in RGB space
containing the pixel's color.  It updates the following data for each
such node:
.TP
.B n\d\s-31\s0\u:
Number of pixels whose color is contained in the RGB cube which this
node represents;
.TP
.B n\d\s-32\s0\u:
Number of pixels whose color is not represented in a node at lower
depth in the tree;  initially,  \fIn\d\s-32\s0\u = 0\fP for all nodes
except leaves of the tree.
.TP
.B S\d\s-3r\s0\u, S\d\s-3g\s0\u, S\d\s-3b\s0\u:
Sums of the red, green, and blue component values for all pixels not
classified at a lower depth.  The combination of these sums and
\fIn\d\s-32\s0\u\fP will ultimately characterize the mean color of a
set of pixels represented by this node.
.TP
.B E:
The distance squared in RGB space between each pixel contained within a
node and the nodes' center.  This represents the quantization error for
a node.
.PP
\fBReduction\fP repeatedly prunes the tree until the number of nodes with
\fIn\d\s-32\s0\u  > 0\fP is less than or equal to the maximum number of colors
allowed in the output image.  On any given iteration over the tree, it
selects those nodes whose \fIE\fP value is minimal for pruning and
merges their color statistics upward.  It uses a pruning threshold,
\fIE\d\s-3p\s0\u\fP, to govern node selection as follows:
.PP
  E\d\s-3p\s0\u = 0
  while number of nodes with (n\d\s-32\s0\u > 0) > required maximum number of colors
      prune all nodes such that E <= E\d\s-3p\s0\u
      Set E\d\s-3p\s0\u  to minimum E in remaining nodes
.PP
This has the effect of minimizing any quantization error when
merging two nodes together.
.PP
When a node to be pruned has offspring, the pruning procedure invokes
itself recursively in order to prune the tree from the leaves upward.
The values of \fIn\d\s-32\s0\u  S\d\s-3r\s0\u, S\d\s-3g\s0\u,\fP  and
\fIS\d\s-3b\s0\u\fP in a node being pruned are always added to the
corresponding data in that node's parent.  This retains the pruned
node's color characteristics for later averaging.
.PP
For each node,  \fIn\d\s-32\s0\u\fP pixels exist for which that node
represents the smallest volume in RGB space containing those pixel's
colors.  When \fIn\d\s-32\s0\u  > 0\fP the node will uniquely define a
color in the output image.  At the beginning of reduction,
\fIn\d\s-32\s0\u = 0\fP  for all nodes except the leaves of the tree
which represent colors present in the input image.
.PP
The other pixel count, \fIn\d\s-31\s0\u\fP,  indicates the total
number of colors within the cubic volume which the node represents.
This includes \fIn\d\s-31\s0\u - n\d\s-32\s0\u\fP pixels whose colors
should be defined by nodes at a lower level in the tree.
.PP
\fBAssignment\fP generates the output image from the pruned tree.  The
output image consists of two parts:  (1)  A color map, which is an
array of color descriptions (RGB triples) for each color present in the
output image; (2)  A pixel array, which represents each pixel as an
index into the color map array.
.PP
First, the assignment phase makes one pass over the pruned color
description tree to establish the image's color map.  For each node
with \fIn\d\s-32\s0\u > 0\fP, it divides \fIS\d\s-3r\s0\u,
S\d\s-3g\s0\u\fP, and \fPS\d\s-3b\s0\u\fP by \fIn\d\s-32\s0\u\fP.  This
produces the mean color of all pixels that classify no lower than this
node.  Each of these colors becomes an entry in the color map.
.PP
Finally, the assignment phase reclassifies each pixel in the pruned
tree to identify the deepest node containing the pixel's color.  The
pixel's value in the pixel array becomes the index of this node's mean
color in the color map.
.PP
Empirical evidence suggests that distances in color spaces such as
YUV, or YIQ correspond to perceptual color differences more closely
than do distances in RGB space.  These color spaces may give better
results when color reducing an image.  Here the algorithm is as described
except each pixel is a point in the alternate color space.  For convenience,
the color components are normalized to the range 0 to a maximum value,
\fIc\d\s-3max\s0\u\fP.  The color reduction can then proceed as described.
.SH "MEASURING COLOR REDUCTION ERROR"
.PP
Depending on the image, the color reduction error may be obvious or
invisible.  Images with high spatial frequencies (such as hair or
grass) will show error much less than pictures with large smoothly
shaded areas (such as faces).  This is because the high-frequency
contour edges introduced by the color reduction process are masked by
the high frequencies in the image.
.PP
To measure the difference between the original and color reduced images
(the total color reduction error), \fBImageMagick\fP sums over all pixels
in an image the distance squared in RGB space between each original
pixel value and its color reduced value. \fBImageMagick\fP prints several error
measurements including the mean error per pixel, the normalized mean error,
and the normalized maximum error.
.PP
The normalized error measurement can be used to compare images.  In
general, the closer the mean error is to zero the more the quantized
image resembles the source image.  Ideally, the error should be
perceptually-based, since the human eye is the final judge of
quantization quality.
.PP
These errors are measured and printed when \fB-verbose\fP and \fB-colors\fI
are specified on the command line:
.TP
.B mean error per pixel:
is the mean error for any single pixel in the image.
.TP
.B normalized mean square error:
is the normalized mean square quantization error for any single pixel in the
image.

This distance measure is normalized to a range between 0 and 1.  It is
independent of the range of red, green, and blue values in the image.
.TP
.B normalized maximum square error:
is the largest normalized square quantization error for any single
pixel in the image.

This distance measure is normalized to a range between 0 and 1.  It is
independent of the range of red, green, and blue values in the image.
.SH SEE ALSO
.B
display(1), animate(1), mogrify(1), import(1), miff(5)
.SH COPYRIGHT
Copyright 1995 E. I. du Pont de Nemours and Company
.PP
Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of E. I. du Pont de Nemours
and Company not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.  E. I. du Pont de Nemours and Company makes no representations
about the suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
.PP
E. I. du Pont de Nemours and Company disclaims all warranties with regard
to this software, including all implied warranties of merchantability
and fitness, in no event shall E. I. du Pont de Nemours and Company be
liable for any special, indirect or consequential damages or any
damages whatsoever resulting from loss of use, data or profits, whether
in an action of contract, negligence or other tortuous action, arising
out of or in connection with the use or performance of this software.
.SH ACKNOWLEDGEMENTS
Paul Raveling, USC Information Sciences Institute, for the original
idea of using space subdivision for the color reduction algorithm.
With Paul's permission, this document is an adaptation from a document he
wrote.
.SH AUTHORS
John Cristy, E.I. du Pont de Nemours and Company Incorporated
