#!/usr/bin/perl
#	BSDI	dbmmanage.sh,v 1.1 1995/12/06 04:25:23 sanders Exp

# ====================================================================
# Copyright (c) 1995 The Apache Group.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer. 
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
#
# 3. All advertising materials mentioning features or use of this
#    software must display the following acknowledgment:
#    "This product includes software developed by the Apache Group
#    for use in the Apache HTTP server project (http://www.apache.org/)."
#
# 4. The names "Apache Server" and "Apache Group" must not be used to
#    endorse or promote products derived from this software without
#    prior written permission.
#
# 5. Redistributions of any form whatsoever must retain the following
#    acknowledgment:
#    "This product includes software developed by the Apache Group
#    for use in the Apache HTTP server project (http://www.apache.org/)."
#
# THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
# EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
# IT'S CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
# OF THE POSSIBILITY OF SUCH DAMAGE.
# ====================================================================
#
# This software consists of voluntary contributions made by many
# individuals on behalf of the Apache Group and was originally based
# on public domain software written at the National Center for
# Supercomputing Applications, University of Illinois, Urbana-Champaign.
# For more information on the Apache Group and the Apache HTTP server
# project, please see <http://www.apache.org/>.


# usage: dbmmanage <DBMfile> <command> <key> <value>
#
# commands: add, delete, view, adduser
#
# no values needed for delete, no keys or values needed for view.
# to change a value, simply use "add".
# adduser encrypts the password:
# dbmmanage <dbm file> adduser <person> <password>

die "Too few arguments.\n" if (@ARGV < 2);

($file,$command,$key,$value) = @ARGV;

$file =~ s/\.db.?$//;		# remove ".db" or ".dbX" extension if any
$file =~ s/\.pag$//;		# remove ".pag" and ".dir" as well.
$file =~ s/\.dir$//;		# these are all common DBM extensions.

if ($command eq "add") {
  dbmopen(%DB, $file, 0664) || die "Error: $!\n";
  $DB{$key} = $value;
  dbmclose(%DB);
  print "Entry $key added with value $value.\n";
} elsif ($command eq "adduser") {
  srand;			# needs to be done only once.
  $salt = &compute_salt(0);	# change to compute_salt(1) for new crypt()
  $hash = crypt($value, $salt);
  dbmopen(%DB, $file, 0664) || die "Error: $!\n";
  $DB{$key} = $hash;
  dbmclose(%DB);
  print "User $key added with password ``$value'', encrypted to $hash\n";
} elsif ($command eq "delete") {
  dbmopen(%DB, $file, 0664) || die "Error: $!\n";
  delete($DB{$key});
  dbmclose(%DB);
} elsif ($command eq "view") {
  dbmopen(%DB, $file, undef) || die "Error: $!\n";
  unless ($key) {
    while (($nkey,$val) = each %DB) {
      print "$nkey = $val\n";
    }
  } else {
    print "$key = $DB{$key}\n";
  } 
  dbmclose(%DB);
} else {
  print "Command unrecognized - must be one of: view, add, adduser, delete.\n";
}

exit(0);

# if $newstyle is 1, then use new style salt (starts with '_' and contains
# four bytes of iteration count and four bytes of salt).  Otherwise, just use
# the traditional two-byte salt.
# see the man page on your system to decide if you have a newer crypt() lib.
# I believe that 4.4BSD derived systems do (at least BSD/OS 2.0 does).
# The new style crypt() allows up to 20 characters of the password to be
# significant rather than only 8.
sub compute_salt {
  local($newstyle) = @_;
  local($salt);
  if ($newstyle) {
    $salt = "_" . &randchar(1) . "a.." . &randchar(4);
  } else {
    $salt = &randchar(2);
  }
  $salt;
}

# return $count random characters
sub randchar {
  local($count) = @_;
  local($str) = "";
  local($enc) =
    "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
  while ($count--) {
    # 64 = length($enc) in call to rand() below
    $str .= substr($enc,int(rand(64))+1,1);
  }
  $str;
}
