/* XWhom - written by Joseph Paparella    Dec 16, 1991
 * University of Massachusetts at Lowell
 *
 * XWhom is a simple X-hack I did one day because I didn't feel like
 * doing real work.  XWhom lists the users on the system in an Athena List
 * Widget.  If you have a .whom file in your home directory, the names in
 * your .whom file will replace the corresponding login names.  Click on the
 * desired user to get information about them and their processes.  XWhom
 * updates the list every 10 seconds.  Press 'Q' to quit.
 *
 * The .whom file contains aliases for login names.  The aliases may have
 * spaces, but will be truncated to 8 characters.  A sample .whom file:
 * login:   alias:
 *
 * root     The Man
 * uucp     mailman
 * jpaparel Joe
 *
 * The -w option just displays users in your .whom file.
 * The -u option lets you adjust the user list refresh interval.
 * The -c option lets you set the default number of columns.
 * The -s option disables scrollbars.
 *
 * Merge in the default resources by typing:  xrdb -merge Xwhom.ad
 * You can edit this file to put in your own default resources then add it
 * to your .Xdefaults file.
 *
 * Please report any problems, suggestions, bug fixes, etc. to me at:
 *   jpaparel@cs.ulowell.edu
 *
 *
 * modified 95/11/08 by Brett Wynkoop wynkoop@wynn.com to run on BSDI v1.1
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <sys/file.h>
#include <stdio.h>
#include <stdlib.h>
#include <utmp.h>
#include <pwd.h>

#define STRSIZE 80
#define MAXUSER 100
#define MAXPALS 100
#define FILEBUF 1024
#define DATASIZ 512
#define GECOSSZ 120

/*************************************************************************
*
* 95/11/08 
*          took out hard coded location of utmp and replaced it with this
*          ifdef section for BSDI 1.1.  Brett Wynkoop wynkoop@wynn.com
*
***************************************************************************/
#ifndef BSDI
#define UTMP "/etc/utmp"
#endif
#ifdef BSDI
#define UTMP "/var/run/utmp"
#endif
void QuitProc();

Display *dpy;
XtAppContext app;
Widget topLevel, label, shell = NULL;
unsigned long interval = 10000;
Bool whomOnly = False;
Bool scrollBars = True;
int count = 0;
int columns = 3;
String items[MAXUSER] = {NULL};
struct utmp entry[MAXUSER];
static char buffer[FILEBUF];

String translationTable = "<Key>q:quit()";
XtActionsRec actionsTable = {"quit", (XtActionProc)QuitProc};

String format = "\
User: %s\n\n\
Name: %s\n\n\
Host: %s\n\n\
Line: %s\n\n\
Login Time: %s\n\n\
Office: %s\n\n\
Home Phone: %s\n\n\
Office Phone: %s\n\n\
Directory: %s\n\n\
%s\n\n\
";

int pals;
struct PalTbl {
  char logName[9];
  char palName[9];
} table[MAXPALS];

int palcmp(e1, e2)
register struct PalTbl *e1;
register struct PalTbl *e2;
{
  return strcmp(e1->palName, e2->palName);
}

int utmpcmp(e1, e2)
register struct utmp *e1;
register struct utmp *e2;
{
  return strncmp(e1->ut_name, e2->ut_name, 8);
}

String getps(index)
int index;
{
  char command[STRSIZE];
  register FILE *fp;
  register String p, e;
  String filename = tmpnam(NULL);

  sprintf(command, "ps -t%c%c > %s\n", entry[index].ut_line[3],
		entry[index].ut_line[4], filename);

  system(command);

  if (!(fp = fopen(filename, "r")))
    return NULL;

  for (p = buffer, e = buffer + 8191; !feof(fp) && p <= e; p++)
    *p = fgetc(fp);
  *(--p) = 0;

  fclose(fp);

  unlink(filename);

  return buffer;
}

void setupInfo(string, index)
register String string;
register int index;
{
  register struct passwd *pwd;
  register String p, q, s;
  char user[9], host[17], line[9], timstr[9], gecos[GECOSSZ];
  register struct PalTbl *pal;
  struct PalTbl key;

  memcpy(key.palName, entry[index].ut_name, 8);
  key.palName[8] = 0;

  qsort(table, pals, sizeof(struct PalTbl), palcmp);
  if (pal = (struct PalTbl *)bsearch(&key, table, pals, sizeof(struct PalTbl),
							  palcmp))
    p = pal->logName;
  else
    p = entry[index].ut_name;

  for (q = user, s = q + 8; *p && q < s; p++, q++)
    *q = *p;
  *q = 0;

  for (p = entry[index].ut_host, q = host, s = q + 16; *p && q < s; p++, q++)
    *q = *p;
  *q = 0;

  for (p = entry[index].ut_line, q = line, s = q + 8; *p && q < s; p++, q++)
    *q = *p;
  *q = 0;

  strftime(timstr, 9, "%I:%M %p", localtime(&entry[index].ut_time));

  pwd = getpwnam(user);
  
  q = gecos;
  p = pwd->pw_gecos;
  for (; *p && !(*p == ',' || *p == ':' || *p == '\n');)
    *q++ = *p++;
  *q = 0;

  q = gecos + 30;
  if (*p && *p != ':')
    for (p++; *p && !(*p == ',' || *p == ':' || *p == '\n'); p++, q++)
	 *q = *p;
  *q = 0;
    
  q = gecos + 60;
  if (*p && *p != ':')
    for (p++; *p && !(*p == ',' || *p == ':' || *p == '\n'); p++, q++)
	 *q = *p;
  *q = 0;

  q = gecos + 90;
  if (*p && *p != ':')
    for (p++; *p && !(*p == ',' || *p == ':' || *p == '\n'); p++, q++)
	 *q = *p;
  *q = 0;

  sprintf(string, format, user, gecos, host, line, timstr,
		gecos + 30, gecos + 90, gecos + 60, pwd->pw_dir, getps(index));
}

void makeTable()
{
  register char c;
  register int i;
  register FILE *fp;
  char filename[STRSIZE];

  strcpy(filename, getenv("HOME"));
  strcat(filename, "/.whom");
  if (!(fp = fopen(filename, "r")))
    return;

  for (pals = 0; !feof(fp); pals++) {
    fscanf(fp, "%s", table[pals].logName);

    while (isspace(c = fgetc(fp)));
    ungetc(c, fp);

    for (i = 0; i < 8; i++)
	 if ((c = fgetc(fp)) == '\n')
	   break;
	 else
	   table[pals].palName[i] = c;

    while (c != '\n' && !feof(fp))
	 c = fgetc(fp);
    ungetc(c, fp);

    table[pals].palName[i] = 0;
  }
  pals--;

  fclose(fp);
}

void setList()
{
  register int fd;
  register struct PalTbl *tmp;
  register int i;
  struct PalTbl key;

  if (*items)
    XtFree(*items);

  if ((fd = open(UTMP, O_RDONLY)) < 0) {
    fprintf(stderr, "Can't open /etc/utmp.\n");
    exit(1);
  }

  qsort(table, pals, sizeof(struct PalTbl), strcmp);

  for (count = 0; read(fd, entry + count, sizeof(struct utmp)) > 0;)
    if (*entry[count].ut_name)
	 if (!whomOnly)
	   count++;
	 else {
	   memcpy(key.logName, entry[count].ut_name, 8);
	   key.logName[8] = 0;
	   if (bsearch(&key, table, pals, sizeof(struct PalTbl), strcmp))
		count++;
	 }

  close(fd);

  *items = XtMalloc((count + 1) * 9);
  items[count] = NULL;

  for (i = 0; i < count; i++) {
    items[i] = items[0] + i * 9;

    memcpy(key.logName, entry[i].ut_name, 8);
    key.logName[8] = 0;
    if (tmp = (struct PalTbl *)bsearch(&key, table, pals,
							    sizeof(struct PalTbl), strcmp))
	 memcpy(entry[i].ut_name, tmp->palName, 8);
    
    memcpy(items[i], entry[i].ut_name, 8);
    items[i][8] = 0;
  }
  qsort(entry, count, sizeof(struct utmp), utmpcmp);
  qsort(*items, count, sizeof(char[9]), strcmp);
}

void processUTmp(list, id)
Widget list;
XtIntervalId *id;
{
  char string[STRSIZE];

  if (!XtIsRealized(list)) {
    XtAppAddTimeOut(app, 500, processUTmp, list);
    return;
  }

  setList();

  XawListChange(list, items, 0, 0, False);
  
  if (count > 1)
    sprintf(string, "XWhom: %d users", count);
  else
    strcpy(string, "XWhom: 1 user");

  XtVaSetValues(label, XtNlabel, string, NULL);
  XtAppAddTimeOut(app, interval, processUTmp, list);
}

void QuitProc(widget, event, params, num_params)
Widget widget;
XEvent *event;
String *params;
Cardinal *num_params;
{
  if (*items)
    XtFree(*items);

  XtDestroyApplicationContext(app);
  XtCloseDisplay(dpy);
  exit(0);
}

void OkCB(widget, client_data, call_data)
Widget widget;
caddr_t client_data;
caddr_t call_data;
{
  XtPopdown(shell);
}

void ListSelectCB(widget, client_data, call_data)
Widget widget;
caddr_t client_data;
register XawListReturnStruct *call_data;
{
  Position x, y;
  Dimension width, height;
  char string[DATASIZ];
  static Widget dialog;

  call_data->list_index = (call_data->list_index >= count) ? count - 1 :
    call_data->list_index;

  setupInfo(string, call_data->list_index);

  if (!shell) {
    Widget button;

    shell = XtCreatePopupShell("shell", transientShellWidgetClass, topLevel,
						 NULL, 0);

    dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, shell,
							  XtNlabel, string, NULL);

    button = XtVaCreateManagedWidget("button", commandWidgetClass, dialog,
							  XtNlabel, "Ok", NULL);
    XtAddCallback(button, XtNcallback, OkCB, NULL);
  }

  XtVaGetValues(topLevel, XtNwidth, &width, XtNheight, &height, NULL);
  XtTranslateCoords(topLevel, (Position)(width >> 1), (Position)(height >> 1),
				&x, &y);

  XtVaGetValues(dialog, XtNwidth, &width, XtNheight, &height, NULL);
  if (!width && !height) {
    XtPopup(shell, XtGrabNone);
    XtVaGetValues(dialog, XtNwidth, &width, XtNheight, &height, NULL);
  }
  x = (x + width > DisplayWidth(dpy, DefaultScreen(dpy))) ? x - width : x;
  y = (y + height > DisplayHeight(dpy, DefaultScreen(dpy))) ? y - height : y;

  XtVaSetValues(dialog, XtNlabel, string, NULL);
  XtVaSetValues(shell, XtNx, x, XtNy, y, NULL);
  XtPopup(shell, XtGrabNone);
}

void main(argc, argv)
int argc;
char *argv[];
{
  char c;
  char hostname[STRSIZE];
  Widget pane, list, viewport;
  XtTranslations translations;
  extern char *optarg;

  while ((c = getopt(argc, argv, "whsu:c:")) != EOF)
    switch (c) {
    case 'u':
	 interval = atoi(optarg) * 1000;
	 break;
    case 'w':
	 whomOnly = True;
	 break;
    case 'c':
	 columns = atoi(optarg);
	 break;
    case 's':
	 scrollBars = False;
	 break;
    case 'h':
	 fprintf(stderr, "Help:");
    default:
	 fprintf(stderr, "\nusage: xwhom [-options...]\n\n");
	 fprintf(stderr, "where options include:\n");
	 fprintf(stderr, "\t-h\t\tThis help message\n");
	 fprintf(stderr, "\t-w\t\tOnly display users in .whom file\n");
	 fprintf(stderr, "\t-s\t\tDisable scrollbars.\n");
	 fprintf(stderr, "\t-c columns\tSet the default number of columns\n");
	 fprintf(stderr, "\t-u interval\tUpdate list every x seconds\n");
	 exit(0);
    }

  XtToolkitInitialize();

  app = XtCreateApplicationContext();

  if (!(dpy = XtOpenDisplay(app, "", *argv, "XWhom", NULL, 0, &argc, argv)))
    XtError("Can't open display.");

  topLevel = XtAppCreateShell(*argv, "XWhom", applicationShellWidgetClass,
						dpy, argv, argc);

  translations = XtParseTranslationTable(translationTable);
  XtAppAddActions(app, &actionsTable, 1);

  pane = XtVaCreateManagedWidget("pane", panedWidgetClass, topLevel,
						   XtNtranslations, translations, NULL);
  
  label = XtVaCreateManagedWidget("name", labelWidgetClass, pane, NULL);

  strcpy(hostname, "Host: ");
  gethostname(hostname + 6, STRSIZE);
  XtVaCreateManagedWidget("host", labelWidgetClass, pane,
					 XtNlabel, hostname, NULL);

  viewport = XtVaCreateManagedWidget("vport", viewportWidgetClass, pane,
							  XtNborderWidth, 1,
							  XtNallowHoriz, scrollBars,
							  XtNallowVert, scrollBars, NULL);
  makeTable();
  setList();
  list = XtVaCreateManagedWidget("list", listWidgetClass, viewport, 
						   XtNlist, items,
						   XtNdefaultColumns, columns,
						   XtNverticalList, True, NULL);
  XtAddCallback(list, XtNcallback, ListSelectCB, NULL);

  processUTmp(list, NULL);

  XtRealizeWidget(topLevel);
  XtAppMainLoop(app);
}
