/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
/*
 * regex-sysv.c	partially emulate re_comp() and re_exec() using System V-style
 *		regcmp() and regex(), as documented in an AT&T System V/386
 *		Release 3.2 programmers manual, and probably found in other
 *		System V versions as well.
 *
 *		This code doesn't address the difference between ed-style
 *		and egrep-style regular expressions.  Amanda uses only very
 *		simple regexes, so is compatible with probably all regex
 *		packages.
 */
#include <libgen.h>

char *re_regexp = 0;

char *re_comp(s)
char *s;
{
    /* returns NULL if string compiled correctly, an error message otherwise */
    /* but, no error message returned in the sysv version, so make one up */

    if(re_regexp)
	free(re_regexp);

    re_regexp = regcmp(s, (char *)0);
    if(re_regexp == 0) return "bad regular expression";
    else return 0;
}

int re_exec(s)
char *s;
{
    /* returns 1 if string matches last regexp, 0 if failed, -1 if error */
    /* but, no way to tell if there was an error in the sysv version */

    return regex(re_regexp, s) != 0;
}
