/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
/*
 * regex-posix.c  partially emulate re_comp() and re_exec() using POSIX.2
 *		style regcomp() and regexec(), as documented in the GNU
 *		regex package.
 *
 *		This code doesn't address the difference between ed-style
 *		and egrep-style regular expressions, let alone GNU and
 *		POSIX styles.  Amanda doesn't use use fancy regexes, so is
 *		compatible with the least-common denominator systems.
 */
#include <sys/types.h>
#include <regex.h>

static regex_t re_regexp;
static int re_initialized;

char *re_comp(s)
char *s;
{
    /* returns NULL if string compiled correctly, an error message otherwise */

    if(re_initialized)
	regfree(&re_regexp);

    re_initialized = 1;

    /* XXX could call regerror for the erstr, but it's not used anyway */
    if(regcomp(&re_regexp, s, REG_NOSUB|REG_NEWLINE)) 
	return "bad regular expression";
    else return 0;
}

int re_exec(s)
char *s;
{
    /* returns 1 if string matches last regexp, 0 if failed, -1 if error */
    if(regexec(&re_regexp, s, 0, (regmatch_t *)0, 0) == 0) return 1;
    else return 0;
}


