/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991,1993 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
/*
 * genversion.c - dump the current Amanda version info.
 */
#include "amanda.h"
#include "version.h"

void main P((void));


#define MARGIN 	70

#define newline()				\
{						\
    printf("  \"%s\\n\",\n", line);		\
    *line = '\0', linelen = 0;			\
}

#define prstr(string)				\
{						\
    len = strlen(string);			\
    if(linelen+len >= MARGIN) { 		\
	newline(); 				\
	sprintf(line, "%*s", indent, "");	\
	linelen = indent;			\
    }						\
    strcat(line, (string)); linelen += len;	\
}

void main()
{
    char line[1024], str[256];
    int  linelen, indent, len;

    printf("/* version.c - generated by genversion.c - DO NOT EDIT! */\n");
    printf("char *version_info[] = {\n");

    *line = '\0', linelen = 0, indent = 0;
    prstr("paths:"); indent = linelen;
    sprintf(str, " DEV_PREFIX=\\\"%s\\\"", DEV_PREFIX); prstr(str);
    sprintf(str, " RDEV_PREFIX=\\\"%s\\\"", RDEV_PREFIX); prstr(str);
    sprintf(str, " DUMP=\\\"%s\\\"", DUMP); prstr(str);
    sprintf(str, " COMPRESS=\\\"%s\\\"", COMPRESS); prstr(str);
    sprintf(str, " MAILER=\\\"%s\\\"", MAILER); prstr(str);
    sprintf(str, " CONFIG_DIR=\\\"%s\\\"", CONFIG_DIR); prstr(str);
    sprintf(str, " LIBEXEC_DIR=\\\"%s\\\"", LIBEXEC_DIR); prstr(str);
    sprintf(str, " BIN_DIR=\\\"%s\\\"", BIN_DIR); prstr(str);
    sprintf(str, " MAN_DIR=\\\"%s\\\"", MAN_DIR); prstr(str);
    newline();

    prstr("defs: ");
    indent = linelen;
#ifdef AIX_BACKUP
    prstr(" AIX_BACKUP");
#endif
#ifdef AIX_HEADERS
    prstr(" AIX_HEADERS");
#endif
#ifdef BROKEN_VOID
    prstr(" BROKEN_VOID");
#endif
#ifdef DUMP_NEEDS_ROOT
    prstr(" DUMP_NEEDS_ROOT");
#endif
#ifdef DUMP_RETURNS_1
    prstr(" DUMP_RETURNS_1");
#endif
#ifdef NEED_FLOCK
    prstr(" NEED_FLOCK");
#endif
#ifdef NEED_REGEX
    prstr(" NEED_REGEX");
#endif
#ifdef NEED_STRERROR
    prstr(" NEED_STRERROR");
#endif
#ifdef NEED_STRSTR
    prstr(" NEED_STRSTR");
#endif
#ifdef NO_DIRENT
    prstr(" NO_DIRENT");
#endif
#ifdef NO_UNISTD
    prstr(" NO_UNISTD");
#endif
#ifdef NO_STDLIB
    prstr(" NO_STDLIB");
#endif
#ifdef NO_MTIO
    prstr(" NO_MTIO");
#endif
#ifdef NO_NDBM
    prstr(" NO_NDBM");
#endif
#ifdef NO_SETSOCKBUF
    prstr(" NO_SETSOCKBUF");
#endif
#ifdef HAVE_SYSVSHM
    prstr(" HAVE_SYSVSHM");
#endif
#ifdef HAVE_MMAP
    prstr(" HAVE_MMAP");
#endif
#ifdef REGEX_FLAVOR
    sprintf(str, " REGEX_FLAVOR=\\\"%s\\\"", stringize(REGEX_FLAVOR));
    prstr(str);
#endif
#ifdef SOLARIS_HEADERS
    prstr(" SOLARIS_HEADERS");
#endif
#ifdef STATFS_BSD
    prstr(" STATFS_BSD");
#endif
#ifdef STATFS_OSF1
    prstr(" STATFS_OSF1");
#endif
#ifdef STATFS_SVR3
    prstr(" STATFS_SVR3");
#endif
#ifdef STATFS_SVR4
    prstr(" STATFS_SVR4");
#endif
#ifdef STATFS_ULTRIX
    prstr(" STATFS_ULTRIX");
#endif
#ifdef STATFS_VFS
    prstr(" STATFS_VFS");
#endif
#ifdef SYSV_SETPGRP
    prstr(" SYSV_SETPGRP");
#endif
#ifdef SYS_DIRENT
    prstr(" SYS_DIRENT");
#endif
#ifdef ASSERTIONS
    prstr(" ASSERTIONS");
#endif
#ifdef BSD_SECURITY
    prstr(" BSD_SECURITY");
#endif
#ifdef KRB4_SECURITY
#define HOSTNAME_INSTANCE	"<hostname>"
    prstr(" KRB4_SECURITY");
    sprintf(str, " SERVER_HOST_PRINCIPLE=\\\"%s\\\"", SERVER_HOST_PRINCIPLE);
    prstr(str);
    sprintf(str, " SERVER_HOST_INSTANCE=\\\"%s\\\"", SERVER_HOST_INSTANCE);
    prstr(str);
    sprintf(str, " SERVER_HOST_KEY_FILE=\\\"%s\\\"", SERVER_HOST_KEY_FILE);
    prstr(str);
    sprintf(str, " CLIENT_HOST_PRINCIPLE=\\\"%s\\\"", CLIENT_HOST_PRINCIPLE);
    prstr(str);
    sprintf(str, " CLIENT_HOST_INSTANCE=\\\"%s\\\"", CLIENT_HOST_INSTANCE);
    prstr(str);
    sprintf(str, " CLIENT_HOST_KEY_FILE=\\\"%s\\\"", CLIENT_HOST_KEY_FILE);
    prstr(str);
    sprintf(str, " TICKET_LIFETIME=%d", TICKET_LIFETIME);
    prstr(str);
#endif
#ifdef CLIENT_LOGIN
    sprintf(str, " CLIENT_LOGIN=\\\"%s\\\"", CLIENT_LOGIN);
    prstr(str);
#endif
#ifdef FORCE_USERID
    prstr(" FORCE_USERID");
#endif
#ifdef USE_VERSION_SUFFIXES
    prstr(" USE_VERSION_SUFFIXES");
#endif
#ifdef HAVE_GZIP
    prstr(" HAVE_GZIP");
#endif
    sprintf(str, " COMPRESS_PATH=\\\"%s\\\"", COMPRESS_PATH);
    prstr(str);
    sprintf(str, " COMPRESS_SUFFIX=\\\"%s\\\"", COMPRESS_SUFFIX);
    prstr(str);
    sprintf(str, " COMPRESS_FAST_OPT=\\\"%s\\\"", COMPRESS_FAST_OPT);
    prstr(str);
    sprintf(str, " COMPRESS_BEST_OPT=\\\"%s\\\"", COMPRESS_BEST_OPT);
    prstr(str);
    sprintf(str, " UNCOMPRESS_CMD=\\\"%s\\\"", UNCOMPRESS_CMD);
    prstr(str);

    newline();

    printf("  0\n};\n");
    exit(0);
}
