/*	BSDI	amanda.h,v 1.1.1.1 1996/01/02 18:11:46 polk Exp	*/

/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991,1994 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
/*
 * amanda.h - the central header file included by all amanda sources.
 */
#ifndef AMANDA_H
#define AMANDA_H

#include "config.h"
#include "options.h"

/*
 * I would prefer that each Amanda module include only those system headers
 * that are locally needed, but on most Unixes the system header files are not
 * protected against multiple inclusion, so this can lead to problems.
 *
 * Also, some systems put key files in different places, so by including 
 * everything here the rest of the system is isolated from such things.
 */
#include <sys/types.h>

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <signal.h>
#include <setjmp.h>
#include <time.h>

#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <fcntl.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include <syslog.h>
#include <pwd.h>
#include <errno.h>

#ifndef NO_UNISTD
#  include <unistd.h>
#endif

#ifndef NO_STDLIB
#  include <stdlib.h>
#endif

#ifdef AIX_HEADERS
#  include <sys/select.h>
#endif

#ifndef NO_DIRENT
#  ifdef SYS_DIRENT
#    include <sys/dirent.h>
#  else
#    include <dirent.h>
#  endif
#endif

#ifndef NO_NDBM
#  include <ndbm.h>
#endif

#ifdef HAVE_SYSVSHM
#  include <sys/ipc.h>
#  include <sys/shm.h>
#else
#  ifdef HAVE_MMAP
#    include <sys/mman.h>
#  endif
#endif

#ifdef KRB4_SECURITY
#  include <des.h>
#  include <krb.h>
#endif

/*
 * Most Unixen declare errno in <errno.h>, some don't.  Some multithreaded
 * systems have errno as a per-thread macro.  So, we have to be careful.
 */
#ifndef errno
extern int errno;
#endif


/*
 * Some older BSD systems don't have these FD_ macros, so if not, provide them.
 */
#ifndef FD_SET
#  define FD_SETSIZE      (sizeof(fd_set) * 8)
#  define FD_SET(n, p)    (((fd_set *) (p))->fds_bits[0] |= (1 << ((n) % 32)))
#  define FD_CLR(n, p)    (((fd_set *) (p))->fds_bits[0] &= ~(1 << ((n) % 32)))
#  define FD_ISSET(n, p)  (((fd_set *) (p))->fds_bits[0] & (1 << ((n) % 32)))
#  define FD_ZERO(p)      memset((p), 0, sizeof(*(p)))
#endif


/* consts from BSDish <sys/file.h>, for SV systems that define NEED_FLOCK */
#ifndef LOCK_EX
#  define LOCK_EX 2
#  define LOCK_UN 8
#endif

/*
 * If void is broken, substitute char.
 */
#ifdef BROKEN_VOID
#  define void char
#endif

/*
 * define prototype macro so that prototypes can be declared in both ANSI
 * and classic C environments.
 */

#if __STDC__
#  define P(parms)	parms
#  define stringize(x) #x
#else
#  define P(parms)	()
#  define stringize(x) "x"
#endif


/*
 * assertions, but call error() instead of abort 
 */
#ifndef ASSERTIONS

#define assert(exp) (0)

#else	/* ASSERTIONS */

#define assert(exp) {if(!(exp)) error("assert: %s false, file %s, line %d", \
				   stringize(exp), __FILE__, __LINE__);}

#endif	/* ASSERTIONS */

/*
 * print debug output, else compile to nothing.
 */
#ifdef DEBUG_CODE
#   define dbopen(filename)    debug_open(filename)
#   define dbclose()    debug_close()
#   define dbprintf(p)  (debug? (debug_printf p, 0) : 0)

void debug_open P((char *filename));
void debug_close P((void));
void debug_printf P((char *format, ...));

#else
#   define dbopen(filename)
#   define dbclose()
#   define dbprintf(p)
#endif

/* amanda #days calculation, with roundoff */

#define SECS_PER_DAY	(24*60*60)
#define days_diff(a, b)	(((b) - (a) + SECS_PER_DAY/2) / SECS_PER_DAY)

/* global constants */

#define AMANDA_SERVICE_DEFAULT	10080
#define KAMANDA_SERVICE_DEFAULT	10081


/* define misc amanda functions */

#define ERR_INTERACTIVE	1
#define ERR_SYSLOG	2
#define ERR_AMANDALOG	4

extern int erroutput_type;
void error P((char *format, ...));
int onerror P((void (*errf)(void)));
void *alloc P((int size));
char *stralloc P((char *str));
time_t tm2time P((struct tm *tmp));

extern int debug;
extern char *version_info[];

#endif	/* !AMANDA_H */
