/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
/* 
 * selfcheck-dump.c - do self-check and send back any error messages
 */
#define DEBUG_CODE

#include "amanda.h"

#define MAXLINE 4096

char line[MAXLINE];
char *pname = "selfcheck-dump";

/* local functions */
static void check_disk P((char *disk, int level));
static void check_overall P((void));
void main P((int argc, char **argv));


void main(argc, argv)
int argc;
char **argv;
{
    int level;
    char disk[256];

    /* initialize */

    chdir("/tmp");
    erroutput_type = (ERR_INTERACTIVE|ERR_SYSLOG);
    umask(0);
    dbopen("/tmp/selfcheck.debug");

    /* handle all service requests */

    while(fgets(line, MAXLINE, stdin)) {
	if(!strncmp(line, "OPTIONS", 7)) {
	    /* we don't recognize any options yet */
	    printf("OPTIONS ;\n");
	    continue;
	}

	if(sscanf(line, "%s %d\n", disk, &level) != 2) goto err;
	check_disk(disk, level);
    }

    check_overall();

    dbclose();
    exit(0);
 err:
    printf("ERROR [BOGUS REQUEST PACKET]\n");
    dbprintf(("REQ packet is bogus\n"));
    dbclose();
    exit(1);
}


static void check_disk(disk, level)
char *disk;
int level;
{
    int tstfd;
    char device[80];

    if(disk[0] == '/') {
	/* XXX better check in this case */
	if(access(disk, R_OK) == -1)
	    printf("ERROR [can not access %s: %s]\n",
		   disk, strerror(errno));
	else
	    printf("OK %s\n", disk);
	return;
    }

    sprintf(device, "%s%s", RDEV_PREFIX, disk);

    if((tstfd = open(device, O_RDONLY)) == -1)
	printf("ERROR [could not open %s: %s]\n",
	       device, strerror(errno));
    else
	printf("OK %s\n", device);
    close(tstfd);

    /* XXX perhaps do something with level: read dumpdates and sanity check */
}

static void check_overall()
{
    if(access(DUMP, X_OK) == -1)
	printf("ERROR [can not execute %s: %s]\n",
	       DUMP, strerror(errno));
    else
	printf("OK %s executable\n", DUMP);
    if(access(COMPRESS_PATH, X_OK) == -1)
	printf("ERROR [can not execute %s: %s]\n",
	       COMPRESS_PATH, strerror(errno));
    else
	printf("OK %s executable\n", COMPRESS_PATH);
    if(access("/etc/dumpdates", R_OK|W_OK) == -1)
	printf("ERROR [can not access /etc/dumpdates: %s]",
	       strerror(errno));
    else
	printf("OK %s readable/writeable\n", "/etc/dumpdates");
}
