/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991 University of Maryland
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: James da Silva, Systems Design and Analysis Group
 *			   Computer Science Department
 *			   University of Maryland at College Park
 */
/*
 * amandad-krb4.c - The Kerberos4 support bits for amandad.c.
 */

extern char errstr[];

#include "krb4-security.h"
int krb4_auth;

void transfer_session_key P((void));
void add_mutual_authenticator P((dgram_t *msg));
int krb4_security_ok P((pkt_t *msg));

#define KEY_PIPE	3
C_Block session_key;
unsigned long auth_cksum;

void transfer_session_key()
{
    int rc, key_pipe[2];

    if(pipe(key_pipe) == -1)
	error("could not open key pipe: %s", strerror(errno));

    rc = write(key_pipe[1], session_key, sizeof session_key);
    if(rc != sizeof session_key)
	if(rc != -1) error("short write to key pipe");
        else error("error writing to key pipe: %s", strerror(errno));
    
    dup2(key_pipe[0], KEY_PIPE);
    close(key_pipe[0]);
    close(key_pipe[1]);
}

void add_mutual_authenticator(msg)
dgram_t *msg;
{
    union {
	char pad[8];		/* minimum size for encryption */
	unsigned long i;
    } mutual;
    int alen, blen;

    blen = sizeof(mutual);
    memset(&mutual, 0, blen);
    mutual.i = auth_cksum+1;

    encrypt_data(&mutual, blen, session_key);

    sprintf(msg->cur, "SECURITY MUTUAL-AUTH %s\n", bin2astr(&mutual, blen));
    alen = strlen(msg->cur);
    msg->cur += alen;
    msg->len += alen;
}

int krb4_security_ok(msg)
pkt_t *msg;
{
    KTEXT_ST ticket;
    AUTH_DAT auth;
    char ticket_str[4096], inst[256];
    struct passwd *pwptr;
    int myuid, rc;

    /* extract the ticket string from the message */

    if((rc = sscanf(msg->security, "TICKET %[^\n]", ticket_str)) != 1) {
	sprintf(errstr, "[bad krb4 security line]");
	return 0;
    }

    /* convert to binary ticket */

    astr2bin(ticket_str, ticket.dat, &ticket.length);

    /* consult kerberos server */

#define HOSTNAME_INSTANCE "*"	/* XXX fix this? - No I think this works ok */

    strcpy(inst, CLIENT_HOST_INSTANCE);
    rc = krb_rd_req(&ticket, CLIENT_HOST_PRINCIPLE, inst, 
		    msg->peer.sin_addr.s_addr, &auth, CLIENT_HOST_KEY_FILE);
    if(rc) {
	sprintf(errstr, "[kerberos error: %s]", krb_err_txt[rc]);
	return 0;
    }

    /* verify checksum */

    dbprintf(("msg checksum %d auth checksum %d\n", 
	      msg->cksum, auth.checksum));

    if(msg->cksum != auth.checksum) {
	sprintf(errstr, "[kerberos error: checksum mismatch]");
	dbprintf(("checksum error: exp %d got %d\n", 
		  auth.checksum, msg->cksum));
	return 0;
    }

    /* save key/cksum for mutual auth and dump encryption */

    memcpy(session_key, auth.session, sizeof(session_key));
    auth_cksum = auth.checksum;

    /* lookup our local user name */

    myuid = getuid();
    if((pwptr = getpwuid(myuid)) == NULL)
        error("error [getpwuid(%d) fails]", myuid);

    /* check the .klogin file */

    if(kuserok(&auth, pwptr->pw_name)) {
	sprintf(errstr, "[access as %s not allowed from %s.%s@%s]",
                pwptr->pw_name, auth.pname, auth.pinst, auth.prealm);
	dbprintf(("kuserok check failed: %s\n", errstr));
	return 0;
    }

    dbprintf(("krb4 security check passed\n"));
    return 1;
}
