/*
	SCCS id:	@(#) vglobal.c	2.5
	Last edit: 	12/20/85 at 19:04:22
	Retrieved: 	6/16/86 at 20:29:51
	SCCS archive:	/vld/src/vdeck/s.vglobal.c

	Author:		Gary S. Moss
			U. S. Army Ballistic Research Laboratory
			Aberdeen Proving Ground
			Maryland 21005
			(301)278-6647 or AV-283-6647
 */
#if ! defined( lint )
static
char	sccsTag[] = "@(#) vglobal.c	2.5	last edit 12/20/85 at 19:04:22";
#endif
#include <stdio.h>

#include "./vextern.h"

int	debug = 0;

char	*cmd[] = {
"",
"C O M M A N D                  D E S C R I P T I O N",
"",
"deck [output file prefix]      Produce COM GEOM card deck.",
"erase                          Erase current list of objects.",
"insert [object[s]]             Add an object to current list.",
"list [object[s]]               Display current list of selected objects.",
"number [solid] [region]        Specify starting numbers for objects.",
"quit                           Terminate run.",
"remove [object[s]]             Remove an object from current list.",
"sort                           Sort table of contents alphabetically.",
"toc [object[s]]                Table of contents of solids database.",
"! [shell command]              Execute a UNIX shell command.",
"",
"NOTE:",
"First letter of command is sufficient, and all arguments are optional.",
"Objects may be specified with string matching operators (*, [], -, ? or \\)",
"as in the UNIX shell.",
0 };

char	*usage[] = {
"",
"v d e c k (2.5)",
"Make COMGEOM decks of objects from a \"vged\" file suitable as",
"input to the Cyber GIFT5 or gift(1V).",
"",
"Usage: vdeck {file}.vg",
"",
0 };

/* Units conversion factor from milimeters to whatever is specified in
	the ident record.  If nothing is specified, unity scaling is used.
	See '3d.h' for defined units and ident record definition.  This
	capability dates back to GED database version (v4).
 */
double	unit_conversion = 1.0;

/* Sorted table of contents.						*/
char	*toc_list[NDIR];

/* List of regions and solids to be processed.				*/
char	*curr_list[NDIR];
int	curr_ct = 0;

/* List of arguments from command line parser.				*/
char	*arg_list[MAXARG];
int	arg_ct = 0;

/* Temporary list of names.						*/
char	*tmp_list[NDIR];
int	tmp_ct = 0;

/* Structure used by setjmp() and longjmp() to save environment.	*/
jmp_buf	env;

/* File names and descriptors.						*/
int	objfd;		char	*objfile;
int	regfd;		char	reg_file[15];
int	solfd;		char	st_file[73];
int	ridfd;		char	id_file[73];
int	idfd, rd_idfd;	char	disc_file[15];
int	rrfd, rd_rrfd;	char	rt_file[73];

/* Counters.								*/
int	nns;		/* Solids.					*/
int	nnr;		/* Regions not members of other regions.	*/
int	numrr;		/* Regions.					*/
int	ndir;		/* Entries in directory.			*/

/* Miscellaneous globals leftover from Keith's KARDS code.		*/
int		regflag, orflag, delsol = 0, delreg = 0;
int		isave;
char		operate, buff[30], name[16];
long		savsol;

/* Structures.								*/
struct deck_ident	d_ident, idbuf;
int		discr[MAXSOL];
mat_t		xform, notrans, identity;
Record		record;
struct findrr	findrr[MAXRR];
char		dir_names[NDIR*10], *dir_last = dir_names;

