/*
 *			L I B F B - I K . C
 *
 *  Merely for the use of RT, a libfb-compatible
 *  interface library to the Ikonas (Adage) RDC-3000
 *  library.
 */
#include "fb.h"

extern int ikfd;		/* defined in iklib.o */
extern int ikhires;		/* defined in iklib.o */

fbsetsize( size )
{
	if( size > 512 )
		ikhires = 1;
}

fbopen( file, mode )
{
	ikopen();
	return( ikfd );
}

fbclear()
{
	ikclear();
}

fb_wmap()
{
	load_map(1);		/* Standard map: linear */
}

fbzoom( xpts, ypts )
{
	if( xpts > 16 )  xpts = 16;
	if( ypts > 16 )  ypts = 16;
	if( xpts < 1 )  xpts = 1;
	if( ypts < 1 )  ypts = 1;
	ikzoom( xpts-1, ypts-1 );
}

fbwindow( xpts, ypts )
{
	register int npts;
	npts = xpts * 2;	/* really, width */

	/* HACK -- we know it's in the upper left corner */
	if( npts <= 32 )  {
		ikwindow( (0)*4, 4063+31 );
	} else if( npts <= 50 )  {
		ikwindow( (0)*4, 4063+31 );
	} else if( npts <= 64 )  {
		ikwindow( (0)*4, 4063+29 );
	} else if( npts <= 128 )  {
		ikwindow( (0)*4, 4063+25 );
	} else if ( npts <= 256 )  {
		ikwindow( (0)*4, 4063+17 );
	}
}

fbwrite( x, y, p, count )
register Pixel *p;
{
	/* assume count=1 */
	ikwpixel( x, y, (p->blue<<16)|(p->green<<8)|(p->red) );
}
