/*
 * @(#)cnlist.h	1.2	7/13/83
 * @(#)Copyright (C) 1983 by National Semiconductor Corp.
 */

/* This is the format of a compressed nlist file.  Such a file is
 * generated by the csym program, and read with the cnlist routine.
 * Such a file only contains a small number of symbols, so that programs 
 * like ps and w can quicky access the few symbols that they need.
 */

#define	CN_MAGIC	017017		/* magic number for the file */

/* The beginning of the file contains the following header: */

struct	cnlist	{
	long	cn_magic;		/* magic number */
	char	*cn_file;		/* file symbols were extracted from */
	time_t	cn_time;		/* write time of file we used */
	long	cn_count;		/* number of nlist entries following */
};

/* After the header, the file contains nlist entries for some symbols.  After
 * all of these, the remainder of the file contains string storage for the
 * names.  All character pointers are relative to the beginning of the file.
 */
