/*	@(#)trap.h	2.5	 */
/*
 * Trap type values
 */

/*
*****************************************************
	The following traps apply to the Motorola 68K
	family of processors.  These defines are used
	by os/trap.c in the UNIX kernel.
*****************************************************
*/

#ifdef	m68k

#define BUSERR	2	/* Bus Error/Segment Violation (SIGBUS) */
#define ADDRERR	3	/* Address Error (SIGSEGV) */
#define INSTERR	4	/* Illegal Instruction Trap (SIGILL) */
#define ZDVDERR	5	/* Zero Divide Trap (SIGFPE) */
#define CHKTRAP	6	/* CHK Trap (SIGSEGV) */
#define TRAPVFT	7	/* TRAPV instruction fault (SIGILL) */
#define PRIVFLT	8	/* privileged instruction fault (SIGILL) */
#define TRCTRAP	9	/* Trace Trap (SIGTRAP) */
#define L1010FT	10	/* Line 1010 Emulator Trap (SIGILL) */
#define L1111FT	11	/* Line 1111 Emulator Trap (SIGILL) */
#define STRAYFT	24	/* Spurious Interrupt */

/*
***************************************************************
	The following are generated by the 68K TRAP instruction
***************************************************************
*/

#define SYSCALL	32	/* TRAP 0 - System Call Trap */
#define BPTFLT	33	/* TRAP 1 - Breakpoint Trap (SIGTRAP) */
#define IOTTRAP	34	/* TRAP 2 - Simulate DEC IOT Trap (SIGIOT) */
#define EMTTRAP	35	/* TRAP 3 - Simulate DEC EMT Trap (SIGEMT) */
#define FPETRAP	36	/* TRAP 4 - Floating Point Exception Trap (SIGFPE) */

#define RESCHED	0	/* Pseudo trap to signal rescheduling */

/*
****************************************************
	The following traps are for the VAX hardware
****************************************************
*/

#else

#define	RSADFLT	0	/* reserved addressing fault */
#define	PRIVFLT	1	/* privileged instruction fault */
#define	BPTFLT	2	/* bpt instruction fault */
#define	XFCFLT	3	/* xfc instruction fault */
#define	RSOPFLT	4	/* reserved operand fault */
#define	SYSCALL	5	/* chmk instruction (syscall trap) */
#define	ARTHTRP	6	/* arithmetic trap */
#define	RESCHED	7	/* software level 1 trap (reschedule trap) */
#define	SEGFLT	8	/* segmentation fault */
#define	PROTFLT	9	/* protection fault */
#define	TRCTRAP	10	/* trace trap */
#define	CMPTFLT	11	/* compatibility mode fault */

#endif
