#   	@(#)bootvec1.s	2.1 
#
#	This module provides a few constants expected by the
#	standard Motorola rom based monitor boot command (bo).
#
# 	The bo command loads SECTORS contiguous sectors into memory
# 	starting with sector FSTSECT.
#
# 	Some monitors also allow the position in memory to be specified.
# 	The EXORmacs monitor, MACSbug ignores this field and
# 	begins loading at location 0.
#
#-----------------------------------------------------------------------


# Constants
	set	FILL,0
	set	VID,0			# volume id
	set	FSTSECT,4		# first boot sector (256 byte)
	set	SECTORS,4		# boot size in sectors
	set	IGNORED,0		# value ignored by MACSbug

# Info Expected by the MACSbug monitor boot command (bo)
# in the first 256 byte sector on the disk.

	org	0
	long	VID
	long	FILL
	long	FILL
	long	FILL
	long	FILL
	long	FSTSECT			# first boot sector (256 byte)
	short	SECTORS			# boot size in sectors
	long	FILL
	long	IGNORED			# position in memory to load boot


	org	248			# EXORmacs peculiarity
	byte	'E,'X,'O,'R,'M,'A,'C,'S

# Currently the next 256 bytes are filled with zero by post processing
# done on the a.out generated by this module.
# The space is reserved for information defining media parameters
# to be added later.

