/*	@(#)instr.c	2.1		*/
static char ID[] = "@(#) instr.c: 1.1 1/6/82";

/*
 * Define various statistic-collection variables used to monitor the
 * internal workings of ld
 *
 *
 * Collection of statistics is automatic. Output of these variables
 * is controlled by the presence of the UN*X file "instr.data". If
 * this file exists and can be opened for "append", these variables
 * are output.  Output occurs only on complete, successful of ld.
 *
 *
 * In addition, there is the standard debug flag, "-dn", which 
 * controls the output of intermediate information to stderr during
 * the ld run. 
 *
 * A SDP profile is generated by using the dflag values of:
 *
 *	>10 :	output to stderr information on calls to the SDP
 *		function repartition()
 *
 *	>12 :	output to stderr additional information on calls
 *		to the SDP function repartition()
 *
 *	>15 :	output to stderr information on calls to the SDP
 *		functions allocate, lock, and unlock. In addition,
 *		indicate when all SDP I/O occurres
 */

long	SDP_read = 0L,		/* calls to read() from within SDP  */
	SDP_write = 0L,		/* calls to write() from within SDP */
	LD_lock = 0L,		/* calls to lock() from within LD   */
	LD_unlock = 0L;		/* calls to unlock() from within LD */

long	noutsyms = 0L,		/* total size of output symbol table*/
	maxrelocsms = 0L;	/* size of largest input symbol tble*/

long	numldsyms = 0L,		/* number of global symbols	    */
	numldaux = 0L,		/* number of aux entreis	    */
	nwalks = 0L,		/* number of collision chain walks  */
	nfwalks = 0L,		/* number of unsuccessful walks	    */
	ncolisns = 0L,		/* number of hashtab[] collisions   */
	maxchain = 0L;		/* max length of a collision chain  */

extern long	allocspc,		/* amount of space myalloc() used   */
		maxalloc;		/* max amount allocated		    */

long	ttime;			/* total elapsed time		    */
struct tbuffer {		/* process and child execution	    */
	long proc_user_time;	/*	times, as returned by the   */
	long proc_system_time;	/*	times() function	    */
	long child_user_time;
	long child_system_time;
	} ptimes;
