      SUBROUTINE LABEL(MODE)
C
C 
C     THIS ROUTINE PROCESSES ALL SYMBOLS USED IN THE ASSEMBLY 
C     PROGRAM.  IT SCANS THE SYMBOL TABLE TO SEE IF A GIVEN SYMBOL
C     IS DEFINED OR NOT 
C 
C 
C 
C     ENTRY PARAMETERS
C        MODE - INDICATES WHETHER DEFINITION OR REFERENCE OF LABEL
C           0 = DEFINITION
C           1 = REFERENCE 
C        ICOL - STARTING COLUMN OF SCAN 
C     EXIT PARAMETERS 
C        CVAL - VALUE OF LABEL ON RETURN
C        JTYPE - SYMBOL TYPE
C           1 = REGULAR SYMBOL
C           2 = ENTRY POINT SYMBOL
C           3 = SET SYMBOL
C           4 = DEF NAME
C           5 = SUB NAME
C        INDEX - INDEX OF SYMBOL IN TABLE 
C        KLEN - IMPLICIT LABEL LENGTH
C        LLEN - EXPLICIT LABEL LENGTH
C        IERR - ERROR STATUS
C           1 = VALID SYMBOL FOUND
C           2 = SYMBOL NOT IN TABLE
C           3 = SYMBOL ERROR
C           4 = SYMBOL TABLE FULL
C   
C   
      INTEGER FTYPE,FLEN
      REAL ITABV(384),LC,LODLC,LCMAX
      COMMON ICRD,IPRT,IPCH,MCFLE,IMFLE,IDFLE,MCREC,IMREC,IDREC,IOREC
      COMMON MLAB,MOPC,IBIT,ICCNT,IWORD,IERRL,IERRI,IEND,LEND,IFRMC
      COMMON LSOR,LIF,LSYM,LREF,LDEF,LOCT,LOBJ,LOBJ1,LOBJ2,LINV
      COMMON ILEN,KLEN,LLEN,FLEN,KWORD,IYFLD,IZFLD
      COMMON IDUP,NDUP,NFLAG,IOFLG,LWORD,LINEL,KFILE
      COMMON IFBIT,ZVAL,CVAL,JREAD,IN(80),INB(80),LINE,IPAGE,LISN
      COMMON IALPH(37),IAST,IDOLR,ISHRP,IAMP,ICOLN
      COMMON IBLNK,ICTAB,ISEMI,ICOMM,IPLUS,IMIN,IMULT,IDIV
      COMMON IRPAR,ILPAR,IATT(9),JATT(5),LATT(9),IFPAR(16),NBASE,JBASE
      COMMON ICOL,IFCOL,MCOL,MLCOL,IOLIN,ICNT,LTITL(50),IADDR(4,12)
      COMMON ITYPE,JTYPE,FTYPE,IERR,IERRS,IOPVA,JCOL,IBUG,IOVER
      COMMON IPASS,LC,IOBIN(128),IPDEF,LODLC,LCMAX,LCMIN,LEN
      COMMON ITAB(4,384),ITABS(384),ITABV,NAME(4),INDEX,INDET
      COMMON ISYM,LTAB,IFORM,ITRUN,ILOUT,IXCOL,NUMER,ITRMI,ITRMO
      COMMON IXTAB(768),MXREF,IXT,IXPNT,IXCNT,IXPAG,MCORE(128)
C
C
C	THE NAMED COMMON VARIABLE IFLD(400) IS A DUMMY ENTRY POINT FOR
C	A MUCH LARGER ARRAY -- DEFINED IN INIT.FOR. 
C
      COMMON /OVRLAY/IFLD(400)
C
C   
      LLEN = 0
      INDEX = 0
      CVAL = 0. 
C     SCAN SYMBOL, PLACE IN NAME BUFFER 
      CALL SYMBL
      IF(IERR-3) 100,920,100
C     CHECK TO SEE IF LABEL IS IN TABLE 
100   IF(ISYM) 120,914,120
120   DO 200 I=1,ISYM 
      DO 150 J=1,IWORD
      IF(ITAB(J,I)-NAME(J)) 200,150,200 
150   CONTINUE
      GO TO 900 
200   CONTINUE
      GO TO 914 
C     CHECK FOR PASS 2
900   INDEX = I 
      IF(IPASS-1) 902,904,902 
902   IF(IPDEF) 903,904,903 
C     CHECK BIT TO SEE IF SYMBOL DEFINED ON PASS 2 YET
903   JTYPE = ITABS(INDEX)
      I = (JTYPE-(JTYPE/16)*16)/8 
      IF(I) 904,914,904 
C     SYMBOL FOUND, GET ITS VALUE AND TYPE
904   IERR = 1
      CVAL = ITABV(INDEX) 
      JTYPE = ITABS(INDEX)
      IF(JTYPE) 905,906,906 
905   JTYPE = -JTYPE/(2**14)+4
      GO TO 9128
C     SET LABEL LENGTH FOR ORDINARY LABELS
906   KLEN = JTYPE/16 
      JTYPE = JTYPE-(JTYPE/8)*8 
C     IF LABEL NOT DEFINED BY EQU OR SET DIRECTIVES, SET LENGTH 
      IF(KLEN) 9128,908,9128
908   DO 912 I=1,IFBIT
C     FORM 2.**(IFBIT-I)
      J = IFBIT-I 
      REAL = 1. 
      IF(J) 909,911,909 
909   DO 910 K=1,J
      REAL = REAL+REAL
910   CONTINUE
911   K = CVAL/REAL 
      IF(K) 9125,912,9125 
912   CONTINUE
      J = -1
9125  KLEN = J+1
9128  IF(LREF+IPASS-3) 990,913,990
913   CALL XREFT(MODE,0)
      GO TO 990 
C     SYMBOL NOT IN TABLE 
914   IERR = 2
      IF(MODE) 990,915,990
915   IF(ISYM-LTAB) 918,940,940 
918   ISYM = ISYM+1 
      INDEX = ISYM
      GO TO 990 
C     SYMBOL ERROR
920   IERR = 3
      GO TO 990 
C     SYMBOL TABLE FULL 
940   IERR = 4
990   RETURN
      END 
 SYMBOL TABLE FULL 
940   IERR = 4
990   RETURN
      END 
