/*  aisdispat.c -- Dispatcher for on-board AIS devices
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */

#include "viosconf.h"
#include "iopacket.h"
#include "viocmds.h"
#include "viostatus.h"
#include "handlers.h"


    PKT_STATE					/* Throw: Errors from drivers */
ais_dispatcher (cmd, dev, pkt)
    int cmd;
    PDD_PTR dev;
    PKT_PTR pkt;

/* ais_dispatcher (cmd, dev, pkt)
 *	in:	cmd		dispatcher function (PDCREATE / PDREMOVE / etc)
 *	in:	dev		bufptr to physical device descriptor
 *	in:	pkt		bufptr to active i/o packet
 *	return:	(PKT_STATE)	current state of i/o packet
 *	thrown:	(?)		(Drivers may throw errors...see note 1 below)
 *
 *	Main dispatcher for AIS local devices (devices whose physical names
 *	begin with the string "AIS:").  This dispatcher might be called for
 *	device creation (PDCREATE) without an active i/o packet, since some
 *	device initialization occurs at initial system startup.
 *
 *	This routine typically resets the dispatcher address to the appropriate
 *	dispatcher for the specified device type.  Therefore, all requests
 *	other than PDCREATE are handled elsewhere.
 *
 */
{
    register char *name;

#ifdef DEBUG3   /*************************************************************/
    if (cmd NE PDCREATE)
	error ("Bad cmd to ais_dispatcher: %d", cmd);
#endif /* DEBUG3 *************************************************************/

    name = *Devname(*dev) + AISSTRL;	/* point to device name after AIS: */

    if (strncmp(name, UARTSTR, UARTSTRL) EQ 0)		/* if TTY... */
	{
	Dispatcher(*dev) = (int(*)()) tty_dispatcher;	/* set new dispatcher */
	return(tty_create(dev,pkt));		/* call driver directly */
	}

    if (strncmp(name, HOSTMEM, HOSTMEML) EQ 0)	/* if HOSTMEM... */
	{
	Dispatcher(*dev) = (int(*)()) hmem_dispatcher;	/* set new dispatcher */
	return(hmem_create(dev,pkt));		/* call driver directly */
	}

    throw(V_NO_DEVICE);				/* no such device */
}
