
/*
 * viosaddr.c: version 3.2 of 6/4/85
 *
 * viosaddr.c -- C source to create RAMviosaddr.m
 * copyright (c) 1984  American Information Systems Corporation
 *
 *	Daniel Steinberg	July, 1984
 *
 *	This file is compiled to produce assembly language output that
 *	is editted (thru abs.sed) to become RAMviosaddr.m in which the
 *	initialized values below are turned into assembler .set directives.
 *	RAMviosaddr.m is included by all VIOS .S files that reference the
 *	Absolute-Addressed RAM area.
 *
 *	NOTE:
 *	Non-fatal warnings will be generated by the c-compiler when symbols
 *	for array locations are compiled.
 */
#include "vinc/viosconf.h"
#include "vinc/viosflags.h"

/* Define macros to make symbol definitions */

#define Makesym(x) unsigned A_/**/x = (unsigned)&x;


/* Locate all Absolute-Addressed RAM symbols in viosflags.h */

Makesym(vios_pool_start)	/* Start of Pool */
Makesym(vios_pool_end)		/* End of Pool */
Makesym(pool)			/* Pool Management Block */
Makesym(poolsize)		/* size of pool */
Makesym(All_failed)		/* True if allocation failure */

#ifdef DEBUG_MAP   /***********************************************************/
Makesym(poolmap)		/* ptr to pool map */
Makesym(mapsize)		/* size of pool map */
#endif /* DEBUG_MAP ***********************************************************/

Makesym(Vdevices)		/* Virtual Device Listhead */
Makesym(Pdevices)		/* Physical Device Listhead */
Makesym(Vqueue)			/* VI/O active request queue */
Makesym(Pqueue)			/* PI/O active request queue */
Makesym(Wqueue)			/* I/O request Wait queue */
Makesym(Imp_modules)		/* Implementation modules */
Makesym(Class_modules)		/* Class handling modules */
Makesym(Operating_systems)	/* OS list */

Makesym(ticks)			/* Count of clock interrupts */
Makesym(Current_os)		/* currently scheduled OS */
Makesym(osutraps)		/* OS entry points for User Traps */
Makesym(Vioexecuting)		/* True during VIO execution */
Makesym(Vioscheduled)		/* True if VIO rescheduled */
Makesym(OSscheduled)		/* True if OS interrupts queued */
Makesym(OS_Completion)		/* True if OS completion ints enabled */
Makesym(Intstate)		/* True during interrupts */
Makesym(Intdepth)		/* Interrupt enable/disable depth */

