h18370
s 00016/00016/00081
d D 1.3 85/02/13 00:38:19 dock 3 2
c  changes for new assembler format
e
s 00001/00002/00096
d D 1.2 84/12/13 15:40:44 dan 2 1
c diagnostic monitor changes
e
s 00098/00000/00000
d D 1.1 84/11/01 22:38:28 dock 1 0
c date and time created 84/11/01 22:38:28 by dock
e
u
U
t
T
I 1
D 2

E 2
/*
 * romsub.s -- Subroutines for the RAMless-Monitor
 * copyright (c) American Information Systems Corporation
 *	Dock Williams
 *	February, 1984		updated for system 5.2 July, 1984
 *
 * chkesc -- Check for ESCAPE on UART-0
 *	in:	r7	return address
 *	Jumps to ramless_quiet of <ESC> typed
 *	Uses R6
 */
D 2

E 2
I 2
	.globl	chkesc
E 2
chkesc:
#ifdef REV_1A /****************** CPU REVISION-1A **********************/
D 3
	tbitb	U_B_RXRDY,@(UART0+U_STAT) /*  incoming char on UART-0? */
E 3
I 3
	tbitb	$U_B_RXRDY,@(UART0+U_STAT) /*  incoming char on UART-0? */
E 3
	bfc	noescape		/*  no....there is no escape */
	movb	@(UART0+U_IDATA),r6	/* yes...read it from UART-0 */
#endif /************************* CPU REVISION-1A **********************/

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
D 3
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/*  incoming char on UART-0? */
E 3
I 3
	tbitb	$U_B_RXRDY,@(UART0+U_STAT)	/*  incoming char on UART-0? */
E 3
	bfc	noescape		/*  no....there is no escape */
	movb	@(UART0+U_IDATA),r6	/*  yes...read it from UART-0 */
#endif /************************* CPU REVISION-2A **********************/

D 3
	andb	0x7F,r6			/* clear extra bits */
	cmpb	r6,ESC			/* ESCAPE? */
E 3
I 3
	andb	$0x7F,r6		/* clear extra bits */
	cmpb	r6,$ESC			/* ESCAPE? */
E 3
	beq	ramless_quiet		/* yes...quit waiting for UART-1 */
noescape:
	jump	0(r7)			/* use return address */

/*  */

/*
 * cvprtb - cvprtw - cvprt3 - cvprtd -- Print hex values
 *	in:	R5	Value to print
 *	in:	R7	Return address
 *	R4	copy of value to print
 *	R3	shift to get significant byte into low byte of register
 *	Prints the hex value (byte, word, or double)
 *	in R5 on the console terminal, and returns thru R7.
 *	Uses R3-R6 for the conversion algorithm.
 */

	/* convert the double word value in r5 to hex and print it */
cvprtd: movd	r5,r4
D 3
	movxbd	-28,r3		/* shift distance */
E 3
I 3
	movxbd	$-28,r3		/* shift distance */
E 3
	br	conv

	/* convert the 3 byte value in r5 to hex and print it */
cvprt3: movd	r5,r4
D 3
	movxbd	-20,r3		/* shift distance */
E 3
I 3
	movxbd	$-20,r3		/* shift distance */
E 3
	br	conv

	/* convert the word value in r5 to hex and print it */
cvprtw: movd	r5,r4
D 3
	movxbd	-12,r3		/* shift distance */
E 3
I 3
	movxbd	$-12,r3		/* shift distance */
E 3
	br	conv

	/* convert the byte value in r5 to hex and print it */
cvprtb: movd	r5,r4
D 3
	movqd	-4,r3		/* shift distance */
E 3
I 3
	movqd	$-4,r3		/* shift distance */
E 3
conv:
	lshd	r3,r5		/* get nibble in lower byte */
D 3
	andb	0x0f,r5		/* mask off the rest */
	cmpb	r5,0x0a		/* is it a digit */
E 3
I 3
	andb	$0x0f,r5	/* mask off the rest */
	cmpb	r5,$0x0a	/* is it a digit */
E 3
	bge	pralph		/* no, print the alpha character */
D 3
	addb	0x30,r5		/* yes convert to digit hex */
E 3
I 3
	addb	$0x30,r5	/* yes convert to digit hex */
E 3
prout:
	addr	nxt4,r6
	br	outc		/* print the converted nibble */
pralph:	
D 3
	addb	0x37,r5		/* convert to alpha hex */
E 3
I 3
	addb	$0x37,r5	/* convert to alpha hex */
E 3
	br	prout
nxt4:
	movd	r4,r5		/* restore r5 */
D 3
	addqd	4,r3		/* rotate more */
	cmpqb	4,r3		/* check if done */
E 3
I 3
	addqd	$4,r3		/* rotate more */
	cmpqb	$4,r3		/* check if done */
E 3
	ble	cvret
	br	conv		/* convert another digit */
cvret:	jump	0(r7)		/* return */

/*  */


	/* crlf -- output a carriage return and line feed */
	/* 	in:	R7	return address */
crlf:
D 3
	movb	CR,r5		/* output carriage return */
E 3
I 3
	movb	$CR,r5		/* output carriage return */
E 3
	addr	plf,r6
	br	outc
plf:
D 3
	movb	LF,r5		/* output line feed */
E 3
I 3
	movb	$LF,r5		/* output line feed */
E 3
	movd	r7,r6
	br	outc

/*  */
E 1
