/*
 * promcrt0.S -- PROM Startup initialization code
 * copyright (c) American Information Systems Corporation
 *
 * Daniel Steinberg
 *	July, 1984
 *
 *	AIS/UNIX-System V.2  code format
 *
 *	This module contains the initial startup code for entering the
 *	AIS Monitor/VIOS.  It MUST be located at the first address in
 *	the program text area, but will work correctly regardless of the
 *	actual address for which it is linked and/or executed.
 *
 *	On initial execution, this code determines where it is running.
 *	If it is at location 0, then a Hard Reset has just occurred
 *	and ROM is mapped over RAM address 0.  If this is the case,
 *	a branch is taken to ensure that the actual ROM addresses are issued.
 *	Once this is done, RAM Mapping may be safely enabled.
 *
 *	To build, the following files must be concatenated (in any order)
 *	after this file:
 *		romtrap.S
 */
	.file	"promcrt.s"

#include "3200config.h"

	.text

	.globl	start
start:
addr0:
	addr	.,r0		/* get current pc */

	cmpqd	$0,r0		/* if zero, reset */
	bne	relocated	/* not reset, someone jumped here */
	movd	$ROMSTART,r0	/* set address of PROM */

#ifdef ABS_AS /****************** ABSOLUTE ADDRESSING ******************/
	jump	relocated	/* skip to absolute location */
#endif /************************* ABSOLUTE ADDRESSING ******************/

#ifdef REL_AS /****************** PC-RELATIVE ADDRESSING ***************/
	jump	(relocated-start)(r0)	/* jump to offset in PROM */
#endif /************************* PC-RELATIVE ADDRESSING ***************/

				/* r0 has address of 'start' */
relocated:
	jump	prominit	/* go to initialization code in prominit.S */
/* romtrap.S -- ROM-Monitor trap handling
 * copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	July, 1984
 *
 *	AIS/UNIX-System V.2  code format
 *
 *	This file establishes an interrupt dispatch table and module table entry
 *	for trap handling within the AIS/ROM-Monitor.  The module table entry
 *	is accessed in the low 64K-bytes of address space only when ROM is
 *	mapped over RAM.  Therefore, traps will not be handled correctly once
 *	RAM-Mapping is enabled.
 *
 */
	.text

/* define macro to compute local routine offsets */
#define VECTOR(x)	.word	(ROMMODTBL - addr0), ((x) - ROMDISPATCH)

	.align	4

ROMMODTBL:		/* ROM-Monitor Interrupt Module Table Entry */
ROMSB:	.double	0
ROMLB:	.double	0
ROMPB:	.double	ROMDISPATCH
	.double	0

	.globl	ROMVECTORS
ROMVECTORS:		/* ROM-Monitor Interrupt Dispatch Table */
	VECTOR(ROMnvi)
	VECTOR(ROMnmi)
	VECTOR(ROMabt)
	VECTOR(ROMfpu)
	VECTOR(ROMill)
	VECTOR(ROMsvc)
	VECTOR(ROMdvz)
	VECTOR(ROMflg)
	VECTOR(ROMbpt)
	VECTOR(ROMtrc)
	VECTOR(ROMund)
	VECTOR(ROMrsv)
	VECTOR(ROMrsv)
	VECTOR(ROMrsv)
	VECTOR(ROMrsv)
	VECTOR(ROMrsv)
	/* Interrupt handlers (interrupts ordinarily disabled) */
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)


/* trap routines */
ROMDISPATCH:

ROMnvi:
        movqd   $0,r0		/* trap number 0 */
        br      ROMtrap
ROMnmi:
        movqd   $1,r0		/* trap number 1 */
        br      ROMtrap
ROMabt:
        movqd   $2,r0		/* trap number 2 */
        br      ROMtrap
ROMfpu:
        movqd   $3,r0		/* trap number 3 */
        br      ROMtrap
ROMill:
        movqd   $4,r0		/* trap number 4 */
        br      ROMtrap
ROMsvc:
        movqd   $5,r0		/* trap number 5 */
        br      ROMtrap
ROMdvz:
        movqd   $6,r0		/* trap number 6 */
        br      ROMtrap
ROMflg:
        movqd   $7,r0		/* trap number 7 */
	br      ROMtrap
ROMbpt:
        addr	@8,r0		/* trap number 8 */
	br	ROMtrap
ROMtrc:
        addr	@9,r0		/* trap number 9 */
	br	ROMtrap
ROMund:
        addr	@10,r0		/* trap number 10 */
	br	ROMtrap
ROMrsv:
        addr	@11,r0		/* reserved traps */
	br	ROMtrap
ROMvec:
        addr	@16,r0		/* vectored interrupts */

ROMtrap:
	addr	_romtrapmsg,r6	/* get address of prefix string */
	addr	trap2,r7	/* set return address */
	jump	printmsg	/* print message */
trap2:
	movd	_trapname[r0:d],r6	/* get address of trap name string */
	addr	ramless_quiet,r7	/* return to ROM-Monitor */
	jump	printmsg		/* after printing trap type */
