/*  dpopen.S -- Constantly open host device
 *  copyright (c)
 *	Daniel Steinberg
 *	October, 1984
 *
 *	AIS/UNIX-System V.2  code format
 *
 */
	.file	"dpopen.S"

#include "3200config.h"

	.text

	.globl	dpopen
dpopen:
	movqb	HOST_MEMENABLE,@(UART_MAPENABLE + U_SETOUT)	/* enable */

linkwait:
	movw	@HOST_CSR,r0	/* look for iop */
	cmpw	r0,$31		/* connect address? */
	bls	linkwait	/* not yet */

	ord	$HOST_WINDOW,r0	/* set correct map address */
	movqb	0,@HOST_MAP	/* low order 64K bytes */

	movw	0(r0),r1	/* get interrupt vector */

	bpt	/* link made */

	movqw	2,0(r0)		/* set acknowledge */
	movw	r1,@HOST_INT	/* poke host */

	bpt	/* let host clear the acknowledge */

lock:
	movw	26(r0),r3	/* get outgoing command */
	cmpqw	0,r3		/* nothing? */
	beq	sndlck		/* send one out */

	bpt	/* invalid outgoing command */

sndlck:
	movqw	6,26(r0)	/* send lock data-page command */
	movw	r1,@HOST_INT	/* poke host */

readtx:
	movw	0(r0),r2	/* read transmitted command */
	cmpqw	0,r2		/* none? */
	beq	readtx
	cmpqw	1,r2		/* last command acknowledge not cleared? */
	beq	readtx
	cmpqw	6,r2		/* report data-page address? */
	beq	txok		/* yup */

	bpt	/* invalid command */

txok:
	movxwd	4(r0),r5	/* get high order */
	lshd	$16,r5		/* shift to high order */
	orw	2(r0),r5	/* read data-page address */
	cmpd	$0x3a000,r5	/* correct address? */
	beq	txright		/* yup */

	bpt	/* illegal data page address */

txright:
	movqw	1,0(r0)		/* acknowledge command */
	movw	r1,@HOST_INT	/* poke host */

readcmd:
	movw	26(r0),r3
	cmpqw	1,r3		/* acknowledge? */
	beq	sndall

	bpt	/* timing error */

sndall:
	movw	$7,28(r0)	/* ALLOC_DATA */
	movqw	0,30(r0)
	movw	$0xa0a0,32(r0)	/* phony vdd number */
	movw	$0x0a0a,34(r0)
	movqw	4,36(r0)	/* 4 bytes long */
	movqw	0,38(r0)
	movw	$9,26(r0)	/* PIOCMD */
	movw	r1,@HOST_INT	/* poke host */

readall:
	movw	0(r0),r2	/* read transmitted command */
	cmpqw	0,r2		/* none? */
	beq	readall
	cmpqw	1,r2		/* last command acknowledge not cleared? */
	beq	readall
	cmpw	$9,r2		/* report status? */
	beq	allok		/* yup */

	bpt	/* invalid command */

allok:
	movw	2(r0),r2	/* get status */
	cmpqb	1,r2		/* success? */
	beq	allstatok

	bpt

allstatok:
	movxwd	8(r0),r2	/* get high order */
	lshd	$16,r2		/* shift to high order */
	orw	6(r0),r2	/* read vdd address */
	cmpd	$0x0a0aa0a0,r2	/* correct address? */
	beq	allvright	/* yup */

	bpt

allvright:
	movxwd	12(r0),r4	/* get high order */
	lshd	$16,r4		/* shift to high order */
	orw	10(r0),r4	/* read vdd address */
	cmpd	$0x9e0,r4	/* correct address? */
	beq	allaright	/* yup */

	bpt

allaright:
	movqw	1,0(r0)		/* acknowledge command */
	movw	r1,@HOST_INT	/* poke host */

	movd	r5,r3		/* get data-page address */
	addd	r4,r3		/* add in offset to get address */
	movd	r3,r2		/* copy address */
	bicd	$0xFFFF0000,r3	/* mask all but 64K window address */
	ord	$HOST_WINDOW,r3	/* set proper virtual address */
	bicd	$0xFF00FFFF,r2	/* mask all but window mapping */
	lshd	$-16,r2		/* shift down to low order */
	movb	r2,@HOST_MAP	/* map data-page */
	movw	$0x4545,0(r3)	/* write dummy name */
	movqw	0,2(r3)		/* asciz termination */
	movqb	0,@HOST_MAP	/* re-map to low memory */

	movw	26(r0),r3
	cmpqw	1,r3		/* acknowledge? */
	beq	sndop

	bpt	/* timing error */

sndop:
	movw	$1,28(r0)	/* OPEN_CHANNEL */
	movqw	0,30(r0)
	movw	$0xa0a0,32(r0)	/* phony vdd number */
	movw	$0x0a0a,34(r0)
	movw	r4,36(r0)	/* offset to name in data-page */
	lshd	$-16,r4		/* shift down hi bits */
	movw	r4,38(r0)
	movqw	2,40(r0)	/* class */
	movqw	0,42(r0)
	movw	$9,26(r0)	/* PIOCMD */
	movw	r1,@HOST_INT	/* poke host */

readop:
	movw	0(r0),r2	/* read transmitted command */
	cmpqw	0,r2		/* none? */
	beq	readop
	cmpqw	1,r2		/* last command acknowledge not cleared? */
	beq	readop
	cmpw	$9,r2		/* report status? */
	beq	opok		/* yup */

	bpt	/* invalid command */

opok:
	movw	2(r0),r2	/* get status */
	cmpqb	-6,r2		/* success? */
	beq	opstatok

	bpt

opstatok:
	movxwd	8(r0),r2	/* get high order */
	lshd	$16,r2		/* shift to high order */
	orw	6(r0),r2	/* read vdd address */
	cmpd	$0x0a0aa0a0,r2	/* correct address? */
	beq	opvright	/* yup */

	bpt

opvright:
	br	txright		/* loop forever */

