h58309
s 00003/00003/00058
d D 3.2 85/02/13 00:46:18 dan 2 1
c System V assembler syntax update
e
s 00061/00000/00000
d D 3.1 84/11/13 16:30:31 dan 1 0
c date and time created 84/11/13 16:30:31 by dan
e
u
U
t
T
I 1
/*  viossvc.S -- Kernel->VIOS supervisor calls
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 *	AIS/UNIX-System V.2  code format
 */
	.file	"viossvc.S"

#include "vioslink.h"

	.text

/*
 * vios_call (func, dev, buf, bufsiz, bufmap,
 *				aux, p1, p2, p3, p4, stat, comp, pri, tmo)
 * vios_acall (&argblock)
 *
 *	Enter a VIOS I/O Request
 */
	.globl	_vios_acall
	.globl	_vios_call
	.globl	_nullrout
_vios_acall:
	movd	4(sp),tos	/* copy the ptr to the argument list */
	br	ioreq
_vios_call:
	addr	4(sp),tos	/* push a ptr to the argument list */
ioreq:
	svc			/* VIOS call */
	.byte	VIO_REQUEST_SVC
	movd	tos,r0		/* return the i/o packet number */
_nullrout:		/* do nothing at all */
D 2
	ret	0
E 2
I 2
	ret	$0
E 2


/*
 * vios_enable_completion ()
 * vios_disable_completion ()
 *
 *	Enable/Disable completion interrupts
 */
	.globl	_vios_enable_completion
_vios_enable_completion:
	svc			/* VIOS call */
	.byte	INT_ENABLE_SVC	/* enable completion interrupts */
D 2
	ret	0
E 2
I 2
	ret	$0
E 2

	.globl	_vios_disable_completion
_vios_disable_completion:
	svc			/* VIOS call */
	.byte	INT_DISABLE_SVC	/* disable completion ints */
D 2
	ret	0
E 2
I 2
	ret	$0
E 2

/*
 * USER_STATE_SVC	changing to user-state
 * MEMCHECK_SVC		check memory bitmap
 * SET_KTRAP_SVC	set vectors for traps from kernel
 * SET_UTRAP_SVC	set vectors for traps from user
 */

E 1
