/*  abusflags.h -- Define static variables for AIS/Bus devices
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef ABUSFLAGS
#define ABUSFLAGS

#ifndef CSOURCE
#define CSOURCE
#endif

#include "viosflags.h"
#include "3200config.h"


/* (VIOSEND defined in viosflags.h) */

/* Define start of AIS/Bus Absolute-Addressed RAM */
#define AISBUSSTART VIOSEND
#define AISBUSEND (AISBUSSTART + sizeof(SBUS_RAM))


/* Define macros to simplify future definitions */

#define Makearam(type, name) type SBUS_/**/name;
#define Makeadef(name) ((SBUS_RAM*)AISBUSSTART)->SBUS_/**/name


/*
 * Define the structure of the AIS/Bus portion of
 *	Absolute-Addressed RAM and define variables
 */

typedef struct {
				/* Define TTY structures */

#ifdef REV_2A /****************** CPU REVISION-2A **********************/

Makearam( UB8	,duart_imr[UARTS/2])		/* saved interrupt masks */
#define duart_imr Makeadef(duart_imr)

#endif /************************* CPU REVISION-2A **********************/


Makearam( unsigned*	,ttypdds[UARTS])	/* Physical Dev Descriptors */
#define ttypdds Makeadef(ttypdds)


	}  SBUS_RAM;


#endif
