# AIS VIOS
# makefile for AIS VIOS
# 10/20/84	dss	created


CC	= ncc
CPP	= /lib/ncpp
AS	= nas
LD	= nld
AR	= nar
NM	= nnm
STRIP	= nstrip
XSTR	= /usr/ucb/xstr
INC5	= ../INC5
SINC	= -I$(INC5)
CINC	= -DCSOURCE -I$(INC5)
CF	= -O
CFLAGS	= ${CINC} ${CF}
CXDEF	= -DBPT=\"bpt\;\"
LDFLAGS = -N
LDLIB	=
#LDLIB	= -lnc

VLINK	= RAMmonsize.h
VADDR	= RAMviosaddr.m

ABSLINK	= $(INC5)/RAMmonsize.m
LIBMON	= $(INC5)/prom2b.run

CMNDIR	= Objects2b
CMNLIB	= ${CMNDIR}/vios.a

3200HEADERS = \
	$(INC5)/3200addr.2a.h $(INC5)/3200conf.2a.h $(INC5)/3200info.2a.h \
	$(INC5)/3200uart.2a.h $(INC5)/3200vctr.2a.h \
	$(INC5)/32032.h $(INC5)/3200icu.h $(INC5)/3200mmu.h

HEADERS = \
	$(INC5)/ais.h $(INC5)/ascii.h $(INC5)/vctype.h $(INC5)/vmdispatch.h \
	abusflags.h devfuncs.h devices.h handlers.h iopacket.h osiopkt.h \
	piocmds.h piostatus.h pktfuncs.h poolfuncs.h viocmds.h \
	viosconf.h viosdefs.h viosflags.h vioslink.h viostatus.h viostypes.h \
	vios3200.h \
	$(VLINK) \
	hostflags.h hostprot.h hostsubrs.h

CFILES	= \
	auxhandlr.c blkaddr.c bufaddr.c clock.c ctrlsubs.c devhandlr.c \
	hostmem.c hypersubs.c infhandlr.c inihandlr.c osentries.c pcthandlr.c \
	pktsubs.c pool.c qsubs.c rdwrtsubs.c recseq.c \
	vcthandlr.c vioinit.c viomain.c vrdhandlr.c vwthandlr.c \
	vios.c \
	aisdispat.c aistty.c tty3200.c err3200.c \
	hstdispat.c hstdriver.c

SFILES	= \
	catch3200.S host3210.S memcheck.S trap3200.S viossvc.S


.PRECIOUS: $(CMNLIB)

.SUFFIXES: .o .c .s .S .L

vios2b:	$(VLINK) $(CMNDIR) $(CMNLIB) \
		$(CMNDIR)/viossize.o $(CMNDIR)/strings.o ld.file $(LIBMON)
	$(LD) ${LDFLAGS} -m ld.file -u start -e start $(LIBMON) \
		$(CMNLIB) \
		$(CMNDIR)/viossize.o $(CMNDIR)/strings.o $(LDLIB) $(LIBMON) \
			-o vios2b >vios2b.map
	$(NM) -xv vios2b > vios2b.sym

$(CMNDIR):
	mkdir $(CMNDIR)

$(CMNDIR)/viossize.o:  $(HEADERS) $(3200HEADERS) viossize.c
	$(CPP) ${CINC} viossize.c > Xviossize.c
	$(CC) -S ${CF} Xviossize.c 
	sed -f abs.sed Xviossize.s | $(CPP) -P > XXviossize.s
	$(AS) -o $(CMNDIR)/viossize.o XXviossize.s
	-rm -f Xviossize.c Xviossize.s XXviossize.s

$(CMNDIR)/strings.o: strings
	${XSTR}
	${CC} ${CFLAGS} -S xs.c
	ed - <rofix.ed xs.s
	${AS} -o xs.o xs.s
	mv xs.o $(CMNDIR)/strings.o
	-rm -f xs.c xs.s

$(VADDR): $(HEADERS) $(3200HEADERS) viosaddr.c
	$(CPP) ${CINC} viosaddr.c > Xviosaddr.c
	$(CC) -S ${CF} Xviosaddr.c
	sed -f abs.sed Xviosaddr.s > $(VADDR)
	-rm -f Xviosaddr.c Xviosaddr.s

$(VLINK): $(ABSLINK)
	sed -e "/.globl/d" -e "s/	.set/#define/g" -e "s/,//g" $(ABSLINK) \
		> $(VLINK)

$(CMNLIB)(catch3200.o): ${3200HEADERS} ${HEADERS} $(VADDR) catch3200.S 

$(CMNLIB)(host3210.o): ${3200HEADERS} ${HEADERS} $(VADDR) host3210.S 

$(CMNLIB)(memcheck.o): ${3200HEADERS} ${HEADERS} $(VADDR) memcheck.S 

$(CMNLIB)(trap3200.o): ${3200HEADERS} ${HEADERS} $(VADDR) trap3200.S 

$(CMNLIB)(viossvc.o): ${3200HEADERS} ${HEADERS} $(VADDR) viossvc.S 

$(CMNLIB): \
	$(CMNLIB)(catch3200.o) \
	$(CMNLIB)(host3210.o) \
	$(CMNLIB)(memcheck.o) \
	$(CMNLIB)(trap3200.o) \
	$(CMNLIB)(viossvc.o) \
	$(CMNLIB)(auxhandlr.o) \
	$(CMNLIB)(blkaddr.o) \
	$(CMNLIB)(bufaddr.o) \
	$(CMNLIB)(clock.o) \
	$(CMNLIB)(ctrlsubs.o) \
	$(CMNLIB)(devhandlr.o) \
	$(CMNLIB)(hostmem.o) \
	$(CMNLIB)(hypersubs.o) \
	$(CMNLIB)(infhandlr.o) \
	$(CMNLIB)(inihandlr.o) \
	$(CMNLIB)(osentries.o) \
	$(CMNLIB)(pcthandlr.o) \
	$(CMNLIB)(pktsubs.o) \
	$(CMNLIB)(pool.o) \
	$(CMNLIB)(qsubs.o) \
	$(CMNLIB)(rdwrtsubs.o) \
	$(CMNLIB)(recseq.o) \
	$(CMNLIB)(vcthandlr.o) \
	$(CMNLIB)(vioinit.o) \
	$(CMNLIB)(viomain.o) \
	$(CMNLIB)(vrdhandlr.o) \
	$(CMNLIB)(vwthandlr.o) \
	$(CMNLIB)(vios.o) \
	$(CMNLIB)(aisdispat.o) \
	$(CMNLIB)(aistty.o) \
	$(CMNLIB)(tty3200.o) \
	$(CMNLIB)(err3200.o) \
	$(CMNLIB)(hstdispat.o) \
	$(CMNLIB)(hstdriver.o)

.c.a:
	${CPP} ${CINC} $*.c | ${XSTR} -c -
	${CC} -c ${CF} ${CXDEF} x.c
	mv x.o $*.o
	$(AR) rvl $(CMNLIB) $*.o 
	-rm -f $*.o x.c

.c.L:
	${CPP} ${CINC} $*.c | ${XSTR} -c -
	${CC} -S ${CF} ${CXDEF} x.c
	mv x.s $*.L
	-rm -f x.c

.S.a:
	${CPP} -P $(SINC) $*.S > X$*.s
	$(AS) -o $*.o X$*.s
	$(AR) rvl $(CMNLIB) $*.o
	-rm -f X$*.s $*.o



lint:
	lint -hbacn ${CFILES}


# We need to worry about assembly sources below also.  We assume there are no
# files involved that begin with `..' except for `..' itself.
#	The rule works by sequentially producing the dependencies for each
#	source file.  It builds each such list by using the C preprocessor to
#	collect all files required by the current source file.  Grep then
#	collects line directive lines, and awk and sed strip out unwanted
#	fields and punctuation.  The final awk formats the dependencies into
#	a compact form.  (The final grep throws away the entry for the source
#	file itself -- this dependency is recorded elsewhere.)
depend:
	rm -f makedep eddep
	for i in ${CFILES};					do	\
		${CC} -E ${CFLAGS} $$i				|	\
		grep '^#'					|	\
		awk '{ print $$3 }'				|	\
		sed -e 's|/[^/]*/\.\.||g' -e 's|"||g'		|	\
		sort -u						|	\
		grep -v "$$i"					|	\
		awk "BEGIN { of = \"$$(CMNLIB)(`basename $$i .c`\" \".o): \
		     ./viosconf.h \"; rec = of }\
		     { if (length(rec \$$0) > 78) { print rec; rec = of \$$0 }\
		      else rec = rec \" \" \$$0 }			\
		     END { print rec }" >> makedep		;	\
	done
	echo '$$r makedep' >>eddep
	echo '/^# DO NOT DELETE THIS LINE/+1,$$d' >>eddep
	echo '$$r makedep' >>eddep
	echo 'w' >>eddep
	cp Makefile Makefile.bak
	ed - Makefile < eddep
	rm makedep eddep

tags:
	/usr/ucb/ctags ${CFILES}

# DO NOT DELETE THIS LINE -- make depends on it
$(CMNLIB)(auxhandlr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(auxhandlr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(auxhandlr.o): 	     ./viosconf.h ./devices.h ./handlers.h
$(CMNLIB)(auxhandlr.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(auxhandlr.o): 	     ./viosconf.h ./pktfuncs.h ./poolfuncs.h
$(CMNLIB)(auxhandlr.o): 	     ./viosconf.h ./viocmds.h ./vios3200.h
$(CMNLIB)(auxhandlr.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(auxhandlr.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(auxhandlr.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(blkaddr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(blkaddr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(blkaddr.o): 	     ./viosconf.h ./devices.h ./handlers.h ./iopacket.h
$(CMNLIB)(blkaddr.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./pktfuncs.h
$(CMNLIB)(blkaddr.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h ./vios3200.h
$(CMNLIB)(blkaddr.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(blkaddr.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(blkaddr.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(bufaddr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(bufaddr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(bufaddr.o): 	     ./viosconf.h ./devices.h ./handlers.h ./iopacket.h
$(CMNLIB)(bufaddr.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./pktfuncs.h
$(CMNLIB)(bufaddr.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h ./vios3200.h
$(CMNLIB)(bufaddr.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(bufaddr.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(bufaddr.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(clock.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(clock.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(clock.o): 	     ./viosconf.h ./devices.h ./handlers.h ./iopacket.h
$(CMNLIB)(clock.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./pktfuncs.h
$(CMNLIB)(clock.o): 	     ./viosconf.h ./viocmds.h ./vios3200.h ./viosconf.h
$(CMNLIB)(clock.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h ./viostypes.h
$(CMNLIB)(ctrlsubs.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(ctrlsubs.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(ctrlsubs.o): 	     ./viosconf.h ./devfuncs.h ./devices.h ./piocmds.h
$(CMNLIB)(ctrlsubs.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(ctrlsubs.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(ctrlsubs.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(ctrlsubs.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(devhandlr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(devhandlr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(devhandlr.o): 	     ./viosconf.h ./devfuncs.h ./devices.h
$(CMNLIB)(devhandlr.o): 	     ./viosconf.h ./handlers.h ./iopacket.h
$(CMNLIB)(devhandlr.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./pktfuncs.h
$(CMNLIB)(devhandlr.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(devhandlr.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(devhandlr.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(devhandlr.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h  ../INC5/3200addr.2a.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ../INC5/3200config.h ../INC5/3200icu.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ../INC5/3200info.2a.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ../INC5/3200uart.2a.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ../INC5/3200vctr.2a.h ../INC5/32032.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ../INC5/ais.h ../INC5/ascii.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ./abusflags.h ./devices.h ./handlers.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ./hostflags.h ./hostprot.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ./hostsubrs.h ./iopacket.h ./osiopkt.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ./piocmds.h ./piostatus.h ./pktfuncs.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h ./vios3200.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(hostmem.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(hypersubs.o): 	     ./viosconf.h  ../INC5/3200mmu.h ../INC5/32032.h
$(CMNLIB)(hypersubs.o): 	     ./viosconf.h ../INC5/ais.h ../INC5/vctype.h
$(CMNLIB)(hypersubs.o): 	     ./viosconf.h ./RAMmonsize.h ./devices.h
$(CMNLIB)(hypersubs.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h
$(CMNLIB)(hypersubs.o): 	     ./viosconf.h ./pktfuncs.h ./poolfuncs.h
$(CMNLIB)(hypersubs.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(hypersubs.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(hypersubs.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(infhandlr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(infhandlr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(infhandlr.o): 	     ./viosconf.h ./devfuncs.h ./devices.h
$(CMNLIB)(infhandlr.o): 	     ./viosconf.h ./handlers.h ./iopacket.h
$(CMNLIB)(infhandlr.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./pktfuncs.h
$(CMNLIB)(infhandlr.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(infhandlr.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(infhandlr.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(infhandlr.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(inihandlr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(inihandlr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(inihandlr.o): 	     ./viosconf.h ./devices.h ./handlers.h
$(CMNLIB)(inihandlr.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(inihandlr.o): 	     ./viosconf.h ./viocmds.h ./vios3200.h
$(CMNLIB)(inihandlr.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(inihandlr.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(inihandlr.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(osentries.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(osentries.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(osentries.o): 	     ./viosconf.h ./devices.h ./handlers.h
$(CMNLIB)(osentries.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h
$(CMNLIB)(osentries.o): 	     ./viosconf.h ./pktfuncs.h ./poolfuncs.h
$(CMNLIB)(osentries.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(osentries.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(osentries.o): 	     ./viosconf.h ./vioslink.h ./viostypes.h
$(CMNLIB)(pcthandlr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(pcthandlr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(pcthandlr.o): 	     ./viosconf.h ./devfuncs.h ./devices.h
$(CMNLIB)(pcthandlr.o): 	     ./viosconf.h ./handlers.h ./iopacket.h
$(CMNLIB)(pcthandlr.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(pcthandlr.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(pcthandlr.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(pcthandlr.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(pcthandlr.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(pktsubs.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(pktsubs.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(pktsubs.o): 	     ./viosconf.h ./devices.h ./handlers.h ./iopacket.h
$(CMNLIB)(pktsubs.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./pktfuncs.h
$(CMNLIB)(pktsubs.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h ./vios3200.h
$(CMNLIB)(pktsubs.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(pktsubs.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(pktsubs.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(pool.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(pool.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(pool.o): 	     ./viosconf.h ./devices.h ./iopacket.h ./osiopkt.h
$(CMNLIB)(pool.o): 	     ./viosconf.h ./poolfuncs.h ./vios3200.h ./viosconf.h
$(CMNLIB)(pool.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h ./viostypes.h
$(CMNLIB)(qsubs.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(qsubs.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(qsubs.o): 	     ./viosconf.h ./devices.h ./handlers.h ./iopacket.h
$(CMNLIB)(qsubs.o): 	     ./viosconf.h ./osiopkt.h ./pktfuncs.h ./vios3200.h
$(CMNLIB)(qsubs.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(qsubs.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(rdwrtsubs.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(rdwrtsubs.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(rdwrtsubs.o): 	     ./viosconf.h ./devices.h ./handlers.h
$(CMNLIB)(rdwrtsubs.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(rdwrtsubs.o): 	     ./viosconf.h ./pktfuncs.h ./viocmds.h
$(CMNLIB)(rdwrtsubs.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(rdwrtsubs.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(rdwrtsubs.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(recseq.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(recseq.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(recseq.o): 	     ./viosconf.h ./devices.h ./handlers.h ./iopacket.h
$(CMNLIB)(recseq.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./piostatus.h
$(CMNLIB)(recseq.o): 	     ./viosconf.h ./pktfuncs.h ./viocmds.h ./vios3200.h
$(CMNLIB)(recseq.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(recseq.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(vcthandlr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(vcthandlr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(vcthandlr.o): 	     ./viosconf.h ./devfuncs.h ./devices.h
$(CMNLIB)(vcthandlr.o): 	     ./viosconf.h ./handlers.h ./iopacket.h
$(CMNLIB)(vcthandlr.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(vcthandlr.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(vcthandlr.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(vcthandlr.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(vcthandlr.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h  ../INC5/3200addr.2a.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ../INC5/3200config.h ../INC5/3200icu.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ../INC5/3200info.2a.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ../INC5/3200uart.2a.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ../INC5/3200vctr.2a.h ../INC5/32032.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ../INC5/ais.h ../INC5/vctype.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ./RAMmonsize.h ./abusflags.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ./devfuncs.h ./devices.h ./handlers.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ./hostflags.h ./hostprot.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ./pktfuncs.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(vioinit.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(viomain.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(viomain.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(viomain.o): 	     ./viosconf.h ./devfuncs.h ./devices.h ./handlers.h
$(CMNLIB)(viomain.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(viomain.o): 	     ./viosconf.h ./pktfuncs.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(viomain.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(viomain.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(viomain.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(vrdhandlr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(vrdhandlr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(vrdhandlr.o): 	     ./viosconf.h ./devfuncs.h ./devices.h
$(CMNLIB)(vrdhandlr.o): 	     ./viosconf.h ./handlers.h ./iopacket.h
$(CMNLIB)(vrdhandlr.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./pktfuncs.h
$(CMNLIB)(vrdhandlr.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(vrdhandlr.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(vrdhandlr.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(vrdhandlr.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(vwthandlr.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(vwthandlr.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(vwthandlr.o): 	     ./viosconf.h ./devfuncs.h ./devices.h
$(CMNLIB)(vwthandlr.o): 	     ./viosconf.h ./handlers.h ./iopacket.h
$(CMNLIB)(vwthandlr.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./pktfuncs.h
$(CMNLIB)(vwthandlr.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(vwthandlr.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h
$(CMNLIB)(vwthandlr.o): 	     ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(vwthandlr.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(vios.o): 	     ./viosconf.h  ../INC5/3200addr.2a.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ../INC5/3200config.h ../INC5/3200icu.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ../INC5/3200info.2a.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ../INC5/3200uart.2a.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ../INC5/3200vctr.2a.h ../INC5/32032.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ../INC5/ais.h ../INC5/ascii.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ./abusflags.h ./devfuncs.h ./devices.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ./hostflags.h ./hostprot.h ./iopacket.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./pktfuncs.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ./poolfuncs.h ./viocmds.h ./vios3200.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h ./viosflags.h
$(CMNLIB)(vios.o): 	     ./viosconf.h ./viostatus.h ./viostypes.h
$(CMNLIB)(aisdispat.o): 	     ./viosconf.h  ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(aisdispat.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(aisdispat.o): 	     ./viosconf.h ./devices.h ./handlers.h
$(CMNLIB)(aisdispat.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(aisdispat.o): 	     ./viosconf.h ./viocmds.h ./vios3200.h
$(CMNLIB)(aisdispat.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(aisdispat.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(aisdispat.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h  ../INC5/3200addr.2a.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ../INC5/3200config.h ../INC5/3200icu.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ../INC5/3200info.2a.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ../INC5/3200uart.2a.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ../INC5/3200vctr.2a.h ../INC5/32032.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ../INC5/ais.h ../INC5/ascii.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ./devices.h ./handlers.h ./iopacket.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ./osiopkt.h ./piocmds.h ./piostatus.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ./pktfuncs.h ./poolfuncs.h ./viocmds.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ./vios3200.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(aistty.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h  ../INC5/3200addr.2a.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ../INC5/3200config.h ../INC5/3200icu.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ../INC5/3200info.2a.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ../INC5/3200uart.2a.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ../INC5/3200vctr.2a.h ../INC5/32032.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ../INC5/ais.h ../INC5/ascii.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ./abusflags.h ./devices.h ./vios3200.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(tty3200.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(err3200.o): 	     ./viosconf.h 
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h  ../INC5/3200addr.2a.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ../INC5/3200config.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ../INC5/3200icu.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ../INC5/3200info.2a.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ../INC5/3200uart.2a.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ../INC5/3200vctr.2a.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ../INC5/vctype.h ./RAMmonsize.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ./abusflags.h ./devices.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ./handlers.h ./hostflags.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ./hostprot.h ./hostsubrs.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ./viocmds.h ./vios3200.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(hstdispat.o): 	     ./viosconf.h ./viostypes.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h  ../INC5/3200addr.2a.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ../INC5/3200config.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ../INC5/3200icu.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ../INC5/3200info.2a.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ../INC5/3200uart.2a.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ../INC5/3200vctr.2a.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ../INC5/32032.h ../INC5/ais.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ../INC5/ascii.h ../INC5/vctype.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./RAMmonsize.h ./abusflags.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./devfuncs.h ./devices.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./handlers.h ./hostflags.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./hostprot.h ./hostsubrs.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./iopacket.h ./osiopkt.h ./piocmds.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./pktfuncs.h ./poolfuncs.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./viocmds.h ./vios3200.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./viosconf.h ./viosdefs.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./viosflags.h ./viostatus.h
$(CMNLIB)(hstdriver.o): 	     ./viosconf.h ./viostypes.h
