
#
# %M%: version %I% of %H%
# 
# makefile for AIS/3200 proms
#

PFX	= n
LDFLAGS = -N
LD	= ${PFX}ld
NM	= ${PFX}nm
STRIP	= ${PFX}strip

all: vios

vios5: 
	cd glue; $(MAKE) -$(MAKEFLAGS) PFX=$(PFX) all
	cd ramless; $(MAKE) -$(MAKEFLAGS) PFX=$(PFX) all
	cd monitor; $(MAKE) -$(MAKEFLAGS) PFX=$(PFX) all
	cd general; $(MAKE) -$(MAKEFLAGS) PFX=$(PFX)  all
	cd vios; $(MAKE) -$(MAKEFLAGS) PFX=$(PFX) all
	$(LD) ${LDFLAGS} ld.file -u start -e start glue/glue.a \
		glue/ramsize.o monitor/strings.o glue/dummyvios.o -o mon5 
	$(NM) -xn mon5 > vios.nm &

mon5: 
	cd glue; $(MAKE) -$(MAKEFLAGS) PFX=$(PFX) all
	cd ramless; $(MAKE) -$(MAKEFLAGS) PFX=$(PFX) all
	cd monitor; $(MAKE) -$(MAKEFLAGS) PFX=$(PFX) all
	cd general; $(MAKE) -$(MAKEFLAGS) PFX=$(PFX) all
	$(LD) ${LDFLAGS} ld.file -u start -e start \
		glue/glue.a ramless/raml.a monitor/mon.a general/gen.a \
		glue/ramsize.o monitor/strings.o glue/dummyvios.o \
		glue/dummydiag.o -o mon5 
	$(NM) -xn mon5 > mon5.nm &


diagprom: $(LIBDIR) $(LIBMON) $(LIBMON)(diagmsg.o) $(LIBDIR)/romdiag.o \
		$(LIBDIR)/ramsize.o $(LIBDIR)/strings.o \
		$(LIBDIR)/dummyvios.o ld.file
	-$(AR) dvl $(LIBMON) dummydiag.o 
	$(LD) ${LDFLAGS} -m ld.file -u start -e start $(LIBMON) \
		$(LIBDIR)/romdiag.o $(LIBMON) \
		$(LIBDIR)/ramsize.o $(LIBDIR)/strings.o \
		$(LIBDIR)/dummyvios.o \
		-o diag2b >diag2b.map
	$(NM) -xn diag2b > diag2b.sym


# force everything to be recompiled
force:
	-rm -f glue/glue.a
	-rm -f ramless/raml.a
	-rm -f monitor/mon.a
	-rm -f vios/vios.a
	-rm -f general/gen.a
	-rm -f *.o
	$(MAKE) -$(MAKEFLAGS) all

