h23165
s 00026/00026/00129
d D 1.3 85/02/13 00:37:36 dock 3 2
c changes for new assembler format
e
s 00005/00000/00150
d D 1.2 84/11/19 16:06:10 dock 2 1
c added some globl symbols
e
s 00150/00000/00000
d D 1.1 84/11/01 22:38:26 dock 1 0
c date and time created 84/11/01 22:38:26 by dock
e
u
U
t
T
I 1

/*
 * nromio.S -- Character i/o subroutines for the RAMless-Monitor
 * copyright (c) American Information Systems Corporation
 *	Dock Williams
 *	February, 1984		updated for system 5.2 July, 1984
 *
 *
 * printm -- print the null terminated message at the address in r3
 *	in:	r5	string address
 *	in:	r7	return address for when finished printing string
 * uses:
 *	r5 next character to output, low byte
 *	r5 pointer to string, upper three bytes
 *	r6 gets return address for outc
 *	r7 return address, hi level, when finished printing string
 */
I 2
	.globl	printm
	.globl	inc
	.globl	inc1
	.globl	outc

E 2
printm:
	movb	0(r5),r6	/* get character to print */
D 3
	addqd	1,r5		/* increment string pointer */
	cmpqb	0,r6		/* check for null */
E 3
I 3
	addqd	$1,r5		/* increment string pointer */
	cmpqb	$0,r6		/* check for null */
E 3
	beq	prtret		/* are we finished yet */
D 3
	rotd	8,r5		/* store pointer in upper bytes */
E 3
I 3
	rotd	$8,r5		/* store pointer in upper bytes */
E 3
	movb	r6,r5		/* byte to output */
	addr	outret,r6	/* return address for outc */
	br	outc		/* go print the character */
outret:
D 3
	rotd	-8,r5
E 3
I 3
	rotd	$-8,r5
E 3
	br	printm
prtret:


	jump	0(r7)		/* message out use return address */

/*  */


	/* outc -- print out the charcter in r5 to the console
	 *	in:	R5	character to print
	 *	in:	R6	return address for outc
	 *	in:	R7	return address for high level
	 * uses R4, MOD, and SP registers
	 */

outc:

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
D 3
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* characters to read */
E 3
I 3
	tbitb	$U_B_RXRDY,@(UART0+U_STAT)	/* characters to read */
E 3
	bfs	rxc
D 3
	tbitb	U_B_TXRDY,@(UART0+U_STAT)	/* wait til ok to write more */
E 3
I 3
	tbitb	$U_B_TXRDY,@(UART0+U_STAT)	/* wait til ok to write more */
E 3
	bfc	outc
	movb	r5,@(UART0+U_ODATA)		/* write out character */

outcret:
D 3
	tbitb	U_B_TXEMPTY,@(UART0+U_STAT)	/* wait for transmitter empty */
E 3
I 3
	tbitb	$U_B_TXEMPTY,@(UART0+U_STAT)	/* wait for transmitter empty */
E 3
	bfc	outcret				/* before returning */
#endif /************************* CPU REVISION-2A **********************/
	jump	0(r6)			/* use return address */
rxc:
	lprw	mod,r5			/* save the output character */
	lprd	fp,r6			/* and return address */

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
	movb	@(UART0+U_IDATA),r5	/* read the pending character */
#endif /************************* CPU REVISION-2A **********************/

	addr	rxlp,r6		/* set a dummy return address */
D 3
	cmpb	r5,CTRL_S	/* stop output? */
E 3
I 3
	cmpb	r5,$CTRL_S	/* stop output? */
E 3
	beq	inc		/* yes...go wait for an input */
D 3
	cmpb	r5,ESC		/* cancel output? */
E 3
I 3
	cmpb	r5,$ESC		/* cancel output? */
E 3
	beq	ramless_quiet	/* yes...jump to monitor entry */
	br	outc		/* otherwise, throw it away */
rxlp:
D 3
	cmpb	r5,ESC		/* got an input character after CTRL_S */
E 3
I 3
	cmpb	r5,$ESC		/* got an input character after CTRL_S */
E 3
	beq	ramless_quiet	/* jump back quietly */
D 3
	cmpb	r5,CTRL_Q	/* enable output? */
E 3
I 3
	cmpb	r5,$CTRL_Q	/* enable output? */
E 3
	bne	inc		/* no....keep reading */
dooutc:
	sprd	mod,r5		/* CTRL_Q arrived so restore print state */
	sprd	fp,r6		/* and return address */
	br	outc		/* and retry character output */

/*  */

	/* inc */
	/* read a character from the console port */
	/* r5 character read in */
	/* r6 return address */
inc:	

#ifdef REV_1A /****************** CPU REVISION-1A **********************/
D 3
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* incoming character ready? */
E 3
I 3
	tbitb	$U_B_RXRDY,@(UART0+U_STAT)	/* incoming character ready? */
E 3
	bfc	inc			/* no....wait forever */
	movb	@(UART0+U_IDATA),r5		/* yes...get the character */
#endif /************************* CPU REVISION-1A **********************/

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
D 3
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* incoming character ready? */
E 3
I 3
	tbitb	$U_B_RXRDY,@(UART0+U_STAT)	/* incoming character ready? */
E 3
	bfc	inc			/* no....wait forever */
	movb	@(UART0+U_IDATA),r5		/* yes...get the character */
#endif /************************* CPU REVISION-2A **********************/

D 3
	andb	0x7f,r5		/* only look at seven bits */
	cmpb	r5,0x61		/* map to upper case */
E 3
I 3
	andb	$0x7f,r5	/* only look at seven bits */
	cmpb	r5,$0x61	/* map to upper case */
E 3
	blo	uprcas
D 3
	cmpb	r5,0x7a
E 3
I 3
	cmpb	r5,$0x7a
E 3
	bhi	uprcas
D 3
	subb	0x20,r5
E 3
I 3
	subb	$0x20,r5
E 3
uprcas:				/* check for escape */
D 3
	cmpb	ESC,r5
E 3
I 3
	cmpb	$ESC,r5
E 3
	beq	ramless_quiet
r6ret:	jump	0(r6)		/* return to caller */

/*  */

	/* inc1 */
	/* read a character from the alternate port */
	/* abort if ESC from console port */
	/* r5 character read in */
	/* r6 return address */
inc1:	

#ifdef REV_1A /****************** CPU REVISION-1A **********************/
D 3
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* incoming char on UART-0? */
E 3
I 3
	tbitb	$U_B_RXRDY,@(UART0+U_STAT)	/* incoming char on UART-0? */
E 3
	bfc	inc1chk			/* no....check UART-1 */
	movb	@(UART0+U_IDATA),r5	/* yes...read it from UART-0 */
D 3
	andb	0x7F,r5			/* clear extra bits */
	cmpb	r5,ESC			/* ESCAPE? */
E 3
I 3
	andb	$0x7F,r5		/* clear extra bits */
	cmpb	r5,$ESC			/* ESCAPE? */
E 3
	beq	ramless_quiet		/* yes...quit waiting for UART-1 */
inc1chk:
D 3
	tbitb	U_B_RXRDY,@(UART1+U_STAT)	/* incoming char ready? */
E 3
I 3
	tbitb	$U_B_RXRDY,@(UART1+U_STAT)	/* incoming char ready? */
E 3
	bfc	inc1			/* no....try again */
	movb	@(UART1+U_IDATA),r5	/* yes...get the character */
#endif /************************* CPU REVISION-1A **********************/

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
D 3
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* incoming char on UART-0? */
E 3
I 3
	tbitb	$U_B_RXRDY,@(UART0+U_STAT)	/* incoming char on UART-0? */
E 3
	bfc	inc1chk			/* no....check UART-1 */
	movb	@(UART0+U_IDATA),r5	/* yes...read it from UART-0 */
D 3
	andb	0x7F,r5			/* clear extra bits */
	cmpb	r5,ESC			/* ESCAPE? */
E 3
I 3
	andb	$0x7F,r5			/* clear extra bits */
	cmpb	r5,$ESC			/* ESCAPE? */
E 3
	beq	ramless_quiet		/* yes...quit waiting for UART-1 */
inc1chk:
D 3
	tbitb	U_B_RXRDY,@(UART1+U_STAT)	/* incoming char ready? */
E 3
I 3
	tbitb	$U_B_RXRDY,@(UART1+U_STAT)	/* incoming char ready? */
E 3
	bfc	inc1			/* no....try again */
	movb	@(UART1+U_IDATA),r5	/* yes...get the character */
#endif /************************* CPU REVISION-2A **********************/

	br	r6ret			/* use return address */

E 1
