/* promhdr.h -- Header file for AIS/3200 PROM source compilations
 *	(c)
 *
 *	Daniel Steinberg
 *	March, 1984
 */
#ifndef PROMHDR
#define PROMHDR


/* Define DEBUG_MONITOR (before monflags.h) to enable AIS/RAM-Monitor debug */
#define DEBUG_MONITOR

/* define special codes and flags */

/* round mod table size up to this boundary */
#define MOD_ROUNDING	0x100

/* round VIOS pool base up to this boundary */
#define POOL_ROUNDING	0x04

/* define special Host Non-destructive Reset command byte */
#define SPECIAL_RESET	0xFF


#define N1KB	0x400
#define N2KB	0x800
#define N4KB	0x1000
#define N8KB	0x2000
#define N16KB	0x4000
#define N32KB	0x8000
#define N512KB	0x80000
#define N16MB	0x1000000

#define GRAIN	N8KB		/* number of bytes in a memory block */

#define MAPPTS	(N16MB/GRAIN)	/* number of blocks of memory to map */
#define MAPSIZ	(MAPPTS/8)	/* number of bytes in Memory Bitmap */

#define MON_STACKSIZE  N2KB	/* size, in bytes, of RAM-Monitor stack */
#define VIOS_STACKSIZE N2KB	/* size, in bytes, of VIOS stack */


#define XPDSIZ	4		/* external procedure entry size */
#define MODSIZ	16		/* module table entry size */
#define INTSIZ	XPDSIZ*16	/* non-vectored interrupt table size */

#define BOARDGRAIN	N512KB	/* smallest memory board size */

#endif
