/*  3200icu.h -- Define Interrupt Control Unit Structures
 *  copyright (c)
 *
 *	Daniel Steinberg
 *	March, 1984
 */
#ifndef ICU3200
#define ICU3200


#define	ICU_HVCT	0x00	/* hardware vector */
#define	ICU_SVCT	0x04	/* software vector */
#define	ICU_ELTG0	0x08	/* edge/level triggering */
#define	ICU_ELTG1	0x0c	/* edge/level triggering */
#define	ICU_TPL0	0x10	/* triggering polarity */
#define	ICU_TPL1	0x14	/* triggering polarity */
#define	ICU_IPND0	0x18	/* interrupts pending */
#define	ICU_IPND1	0x1c	/* interrupts pending */
#define	ICU_ISRV0	0x20	/* interrupts in-service */
#define	ICU_ISRV1	0x24	/* interrupts in-service */
#define	ICU_IMSK0	0x28	/* interrupt mask */
#define	ICU_IMSK1	0x2c	/* interrupt mask */
#define	ICU_CSRC0	0x30	/* cascaded source */
#define	ICU_CSRC1	0x34	/* cascaded source */
#define	ICU_FPRT0	0x38	/* first priority */
#define	ICU_FPRT1	0x3c	/* first priority */
#define	ICU_MCTL	0x40	/* mode control */
#define	ICU_OCASN	0x44	/* ouput clock assignment */
#define	ICU_CIPTR	0x48	/* counter interrupt pointer */
#define	ICU_PDAT	0x4c	/* port data */
#define	ICU_IPS		0x50	/* interrupt/port select */
#define	ICU_PDIR	0x54	/* port direction */
#define	ICU_CCTL	0x58	/* counter control */
#define	ICU_CICTL	0x5c	/* counter interrupt control */
#define	ICU_LCSV0	0x60	/* L-counter starting value */
#define	ICU_LCSV1	0x64	/* L-counter starting value */
#define	ICU_HCSV0	0x68	/* H-counter starting value */
#define	ICU_HCSV1	0x6c	/* H-counter starting value */
#define	ICU_LCCV0	0x70	/* L-counter current value */
#define	ICU_LCCV1	0x74	/* L-counter current value */
#define	ICU_HCCV0	0x78	/* H-counter current value */
#define	ICU_HCCV1	0x7c	/* H-counter current value */


/* ICU mode register definitions */
#define I_T16N8	0x1
#define I_NTAR	0x2
#define I_FRZ	0x8
#define I_CLKM	0x10
#define I_COUTM	0x20
#define I_COUTD	0x40
#define I_CFRZ	0x80

/* ICU counter control definitions */
#define I_CDCRL	0x1
#define I_CDCRH	0x2
#define I_CRUNL	0x4
#define I_CRUNH	0x8
#define I_COUT0	0x10
#define I_COUT1	0x20
#define I_CFNPS	0x40
#define I_CCON	0x80

/* counter interrupt control */
#define I_WENL	0x1
#define I_CIEL	0x2
#define I_CIRL	0x4
#define I_CERL	0x8
#define I_WENH	0x10
#define I_CIEH	0x20
#define I_CIRH	0x40
#define I_CERH	0x80

/* set pending interrupt */
#define I_ISET	0x80
#define I_ICLR	0x00
#define I_ICLRALL	0x40

/* include the following only if C-compilations */

#ifdef CSOURCE
/* Define interrupt controller structure */

typedef struct
	{
	byt hvct;
	byt svct;
	byt eltg0;
	byt eltg1;
	byt tpl0;
	byt tpl1;
	byt ipnd0;
	byt ipnd1;
	byt isrv0;
	byt isrv1;
	byt imsk0;
	byt imsk1;
	byt csrc0;
	byt csrc1;
	byt fprt0;
	byt fprt1;
	byt mctl;
	byt ocasn;
	byt ciptr;
	byt pdat;
	byt ips;
	byt pdir;
	byt cctl;
	byt cictl;
	byt lcsv0;
	byt lcsv1;
	byt hcsv0;
	byt hcsv1;
	byt lccv0;
	byt lccv1;
	byt hccv0;
	byt hccv1;
	} int_controller;
#endif

#endif
